/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.amygdalum.testrecorder.util.AttachableClassFileTransformer;
import net.amygdalum.testrecorder.util.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class AllLambdasSerializableTransformer
extends AttachableClassFileTransformer
implements ClassFileTransformer {
    private static final int IS_SERIALIZABLE_PARAMETER_LOCAL = 7;

    public Collection<Class<?>> filterClassesToRetransform(Class<?>[] loaded) {
        for (Class<?> clazz : loaded) {
            if (!"java.lang.invoke.InnerClassLambdaMetafactory".equals(clazz.getName())) continue;
            return Collections.singleton(clazz);
        }
        return Collections.emptyList();
    }

    public Collection<Class<?>> getClassesToRetransform() {
        try {
            return Collections.singletonList(Class.forName("java.lang.invoke.InnerClassLambdaMetafactory"));
        }
        catch (ClassNotFoundException e) {
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        boolean aquired = this.lock.acquire();
        if (!aquired) {
            return null;
        }
        try {
            if (className != null && className.equals("java/lang/invoke/InnerClassLambdaMetafactory")) {
                ClassReader cr = new ClassReader(classfileBuffer);
                ClassNode classNode = new ClassNode();
                cr.accept((ClassVisitor)classNode, 0);
                classNode.methods.stream().filter(method -> "<init>".equals(method.name)).findFirst().ifPresent(method -> {
                    Optional<VarInsnNode> serialized = this.findIsSerializeableLocalVariable((MethodNode)method);
                    serialized.ifPresent(val -> method.instructions.set((AbstractInsnNode)val, (AbstractInsnNode)new InsnNode(4)));
                });
                ClassWriter out = new ClassWriter(3);
                classNode.accept((ClassVisitor)out);
                byte[] byArray = out.toByteArray();
                return byArray;
            }
            byte[] cr = null;
            return cr;
        }
        catch (Throwable e) {
            Logger.error((Object[])new Object[]{"transformation error: ", e});
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.lock.release();
        }
    }

    private Optional<VarInsnNode> findIsSerializeableLocalVariable(MethodNode method) {
        return this.stream(method.instructions.iterator()).filter(node -> node instanceof VarInsnNode).map(node -> (VarInsnNode)node).filter(node -> node.getOpcode() == 21).filter(node -> node.var == 7).findFirst();
    }

    private <T> Stream<T> stream(Iterator<T> iterator) {
        Spliterator<T> spliterator = Spliterators.spliteratorUnknownSize(iterator, 0);
        return StreamSupport.stream(spliterator, false);
    }
}

