/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.amygdalum.testrecorder.util.IdentityWorkSet;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class ClassNodeManager {
    private Map<String, ClassNode> cache = new HashMap<String, ClassNode>();

    public ClassNode fetch(String className, ClassLoader loader) throws IOException {
        ClassNode classNode = this.cache.get(className);
        if (classNode == null) {
            ClassReader cr = this.readerFor(className, loader);
            classNode = new ClassNode();
            cr.accept((ClassVisitor)classNode, 0);
            this.cache.put(className, classNode);
        }
        return classNode;
    }

    private ClassReader readerFor(String className, ClassLoader loader) throws IOException {
        if (loader == null) {
            return new ClassReader(className);
        }
        InputStream stream = loader.getResourceAsStream(className.replace('.', '/') + ".class");
        if (stream == null) {
            return new ClassReader(className);
        }
        return new ClassReader(stream);
    }

    public ClassNode register(byte[] buffer) {
        ClassReader cr = new ClassReader(buffer);
        ClassNode classNode = new ClassNode();
        cr.accept((ClassVisitor)classNode, 0);
        this.cache.put(classNode.name, classNode);
        return classNode;
    }

    public MethodNode fetch(ClassNode classNode, String methodName, String methodDesc, ClassLoader loader) throws IOException, NoSuchMethodException {
        ClassNode currentClassNode = classNode;
        IdentityWorkSet interfaces = new IdentityWorkSet();
        while (currentClassNode != null) {
            for (MethodNode method : currentClassNode.methods) {
                if (!method.name.equals(methodName) || !method.desc.equals(methodDesc)) continue;
                return method;
            }
            interfaces.addAll((Collection)currentClassNode.interfaces);
            currentClassNode = currentClassNode.superName == null ? null : this.fetch(currentClassNode.superName, loader);
        }
        while (interfaces.hasMoreElements()) {
            String interfaceName = (String)interfaces.remove();
            currentClassNode = this.fetch(interfaceName, loader);
            for (MethodNode method : currentClassNode.methods) {
                if (!method.name.equals(methodName) || !method.desc.equals(methodDesc)) continue;
                return method;
            }
            interfaces.addAll((Collection)currentClassNode.interfaces);
        }
        throw new NoSuchMethodException(methodName + methodDesc);
    }
}

