/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder;

import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.amygdalum.testrecorder.DefaultSerializerSession;
import net.amygdalum.testrecorder.SnapshotManager;
import net.amygdalum.testrecorder.profile.AgentConfiguration;
import net.amygdalum.testrecorder.profile.Classes;
import net.amygdalum.testrecorder.profile.Fields;
import net.amygdalum.testrecorder.profile.SerializationProfile;
import net.amygdalum.testrecorder.serializers.ArraySerializer;
import net.amygdalum.testrecorder.serializers.EnumSerializer;
import net.amygdalum.testrecorder.serializers.GenericSerializer;
import net.amygdalum.testrecorder.serializers.LambdaSerializer;
import net.amygdalum.testrecorder.serializers.ProxySerializer;
import net.amygdalum.testrecorder.serializers.SerializerFacade;
import net.amygdalum.testrecorder.types.AnalyzedObject;
import net.amygdalum.testrecorder.types.ContextSnapshot;
import net.amygdalum.testrecorder.types.MethodSignature;
import net.amygdalum.testrecorder.types.OverrideSerializer;
import net.amygdalum.testrecorder.types.Profile;
import net.amygdalum.testrecorder.types.SerializationException;
import net.amygdalum.testrecorder.types.SerializedInput;
import net.amygdalum.testrecorder.types.SerializedOutput;
import net.amygdalum.testrecorder.types.SerializedReferenceType;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.types.Serializer;
import net.amygdalum.testrecorder.types.SerializerSession;
import net.amygdalum.testrecorder.util.Distinct;
import net.amygdalum.testrecorder.util.IdentityWorkSet;
import net.amygdalum.testrecorder.util.Logger;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedLiteral;
import net.amygdalum.testrecorder.values.SerializedNull;

public class ConfigurableSerializerFacade
implements SerializerFacade {
    private Map<Class<?>, Serializer<?>> serializers;
    private ArraySerializer arraySerializer;
    private EnumSerializer enumSerializer;
    private LambdaSerializer lambdaSerializer;
    private ProxySerializer proxySerializer;
    private GenericSerializer genericSerializer;
    private List<Classes> classExclusions;
    private List<Classes> classFacades;
    private List<Fields> fieldExclusions;
    private List<Fields> fieldFacades;

    public ConfigurableSerializerFacade(AgentConfiguration config) {
        this.serializers = ConfigurableSerializerFacade.setupSerializers(config);
        this.arraySerializer = new ArraySerializer();
        this.enumSerializer = new EnumSerializer();
        this.lambdaSerializer = new LambdaSerializer();
        this.proxySerializer = new ProxySerializer();
        this.genericSerializer = new GenericSerializer();
        this.classExclusions = ConfigurableSerializerFacade.classExclusions(config);
        this.classFacades = ConfigurableSerializerFacade.classFacades(config);
        this.fieldExclusions = ConfigurableSerializerFacade.fieldExclusions(config);
        this.fieldFacades = ConfigurableSerializerFacade.fieldFacades(config);
    }

    private static List<Classes> classExclusions(AgentConfiguration config) {
        ArrayList<Classes> excluded = new ArrayList<Classes>(config.loadConfiguration(SerializationProfile.class, new Object[0]).getClassExclusions());
        excluded.addAll(ConfigurableSerializerFacade.testrecorderClasses());
        return excluded;
    }

    private static List<Classes> classFacades(AgentConfiguration config) {
        ArrayList<Classes> facades = new ArrayList<Classes>(config.loadConfiguration(SerializationProfile.class, new Object[0]).getClassFacades());
        facades.addAll(ConfigurableSerializerFacade.testrecorderClasses());
        return facades;
    }

    private static List<Classes> testrecorderClasses() {
        return Arrays.asList(Classes.byDescription(SnapshotManager.class), Classes.byDescription(ContextSnapshot.class), Classes.byDescription(SerializerFacade.class), Classes.byDescription(ConfigurableSerializerFacade.class), Classes.byDescription(SerializerSession.class), Classes.byDescription(DefaultSerializerSession.class), Classes.byDescription(Profile.class), Classes.byDescription(Logger.class), Classes.byPackage("net.amygdalum.testrecorder.values"));
    }

    private static List<Fields> fieldExclusions(AgentConfiguration config) {
        ArrayList<Fields> excluded = new ArrayList<Fields>(config.loadConfiguration(SerializationProfile.class, new Object[0]).getFieldExclusions());
        return excluded;
    }

    private static List<Fields> fieldFacades(AgentConfiguration config) {
        ArrayList<Fields> facades = new ArrayList<Fields>(config.loadConfiguration(SerializationProfile.class, new Object[0]).getFieldFacades());
        return facades;
    }

    private static Map<Class<?>, Serializer<?>> setupSerializers(AgentConfiguration config) {
        IdentityHashMap serializers = new IdentityHashMap();
        for (Serializer serializer : config.loadConfigurations(Serializer.class, new Object[0])) {
            for (Class<?> clazz : serializer.getMatchingClasses()) {
                Serializer existing = serializers.putIfAbsent(clazz, serializer);
                if (existing == null || ConfigurableSerializerFacade.compare(serializer, existing) <= 0) continue;
                serializers.put(clazz, serializer);
            }
        }
        return serializers;
    }

    private static int compare(Serializer<?> serializer1, Serializer<?> serializer2) {
        OverrideSerializer[] overrides1 = (OverrideSerializer[])serializer1.getClass().getDeclaredAnnotationsByType(OverrideSerializer.class);
        OverrideSerializer[] overrides2 = (OverrideSerializer[])serializer2.getClass().getDeclaredAnnotationsByType(OverrideSerializer.class);
        if (Arrays.stream(overrides1).filter(o -> o.value() == serializer2.getClass()).findAny().isPresent()) {
            return 1;
        }
        if (Arrays.stream(overrides2).filter(o -> o.value() == serializer1.getClass()).findAny().isPresent()) {
            return -1;
        }
        return 0;
    }

    @Override
    public SerializedValue serialize(Type type, Object object, SerializerSession session) {
        SerializedValue serializedObject = session.ref(object, type);
        if (serializedObject != null) {
            return serializedObject;
        }
        if (this.isGround(object)) {
            return this.createGround(type, object);
        }
        return this.createObject(Types.serializableOf((Type)type), object, session);
    }

    private SerializedValue createGround(Type type, Object object) {
        if (object == null) {
            SerializedNull nullInstance = SerializedNull.nullInstance();
            return nullInstance;
        }
        if (Types.baseType((Type)type).isPrimitive()) {
            return SerializedLiteral.literal(Types.baseType((Type)type), object);
        }
        return SerializedLiteral.literal(object);
    }

    private SerializedValue createObject(Type type, Object object, SerializerSession session) {
        Profile serialization = session.log(type);
        try {
            SerializedValue serializedValue;
            IdentityWorkSet todo = new IdentityWorkSet();
            todo.add(object);
            LinkedList<Runnable> defer = new LinkedList<Runnable>();
            while (!todo.isEmpty()) {
                Object current = todo.remove();
                AnalyzedObject analyzed = session.analyze(current);
                Serializer<?> serializer = this.fetchSerializer(analyzed.effectiveObject.getClass());
                Object serializedCurrent = serializer.generate(analyzed.effectiveType, session);
                session.resolve(analyzed.object, (SerializedValue)serializedCurrent);
                serializer.components(analyzed.effectiveObject, session).filter((Predicate<?>)Distinct.distinct()).filter(component -> session.find(component) == null).filter(component -> !this.isGround(component)).forEach(arg_0 -> ((IdentityWorkSet)todo).add(arg_0));
                if (serializedCurrent instanceof SerializedReferenceType) {
                    SerializedReferenceType serializedReferenceType = (SerializedReferenceType)serializedCurrent;
                    serializedReferenceType.setId(System.identityHashCode(analyzed.object));
                }
                defer.addFirst(() -> serializer.populate(serializedCurrent, analyzed.effectiveObject, session));
            }
            while (!defer.isEmpty()) {
                Runnable deferred = (Runnable)defer.remove();
                deferred.run();
            }
            SerializedValue serializedValue2 = serializedValue = session.ref(object, type);
            return serializedValue2;
        }
        catch (Throwable e) {
            throw new SerializationException(e);
        }
        finally {
            serialization.stop();
        }
    }

    private boolean isGround(Object component) {
        return component == null || Types.isLiteral(component.getClass());
    }

    private Serializer<?> fetchSerializer(Class<?> clazz) {
        Serializer<?> serializer = this.serializers.get(clazz);
        if (serializer != null) {
            return serializer;
        }
        if (clazz.isArray()) {
            return this.arraySerializer;
        }
        if (clazz.isEnum() || clazz.getSuperclass() != null && clazz.getSuperclass().isEnum()) {
            return this.enumSerializer;
        }
        if (SerializedLambda.class == clazz) {
            return this.lambdaSerializer;
        }
        if (Proxy.isProxyClass(clazz)) {
            return this.proxySerializer;
        }
        return this.genericSerializer;
    }

    @Override
    public SerializedValue[] serialize(Type[] clazzes, Object[] objects, SerializerSession session) {
        return (SerializedValue[])IntStream.range(0, clazzes.length).mapToObj(i -> this.serialize(clazzes[i], objects[i], session)).toArray(SerializedValue[]::new);
    }

    @Override
    public SerializedOutput serializeOutput(int id, MethodSignature signature) {
        return new SerializedOutput(id, signature);
    }

    @Override
    public SerializedInput serializeInput(int id, MethodSignature signature) {
        return new SerializedInput(id, signature);
    }

    @Override
    public SerializerSession newSession() {
        return new DefaultSerializerSession().withClassExclusions(this.classExclusions).withFieldExclusions(this.fieldExclusions).withClassFacades(this.classFacades).withFieldFacades(this.fieldFacades);
    }
}

