/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder;

import java.lang.reflect.Method;
import net.amygdalum.testrecorder.asm.ByteCode;
import net.amygdalum.testrecorder.types.ContextSnapshot;
import net.amygdalum.testrecorder.types.SerializationException;
import net.amygdalum.testrecorder.types.VirtualMethodSignature;
import net.amygdalum.testrecorder.util.Types;

public class ContextSnapshotFactory {
    public static final ContextSnapshotFactory NULL = new ContextSnapshotFactory("null", null, null, null){

        @Override
        public synchronized VirtualMethodSignature signature(ClassLoader loader) {
            return VirtualMethodSignature.NULL;
        }
    };
    private String key;
    private String className;
    private String methodName;
    private String methodDesc;

    public ContextSnapshotFactory(String key, String className, String methodName, String methodDesc) {
        this.key = key;
        this.className = className;
        this.methodName = methodName;
        this.methodDesc = methodDesc;
    }

    public synchronized VirtualMethodSignature signature(ClassLoader loader) {
        try {
            Class clazz = ByteCode.classFrom((String)this.className, (ClassLoader)loader);
            Method method = Types.getDeclaredMethod((Class)clazz, (String)this.methodName, (Class[])ByteCode.argumentTypesFrom((String)this.methodDesc, (ClassLoader)loader));
            return VirtualMethodSignature.fromDescriptor(clazz, method);
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            throw new SerializationException(e);
        }
    }

    public ContextSnapshot createSnapshot(ClassLoader loader) {
        return new ContextSnapshot(System.currentTimeMillis(), this.key, this.signature(loader));
    }
}

