/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder;

import java.lang.invoke.SerializedLambda;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.amygdalum.testrecorder.asm.ByteCode;
import net.amygdalum.testrecorder.profile.Classes;
import net.amygdalum.testrecorder.profile.Excluded;
import net.amygdalum.testrecorder.profile.Facade;
import net.amygdalum.testrecorder.profile.Fields;
import net.amygdalum.testrecorder.types.AnalyzedObject;
import net.amygdalum.testrecorder.types.Profile;
import net.amygdalum.testrecorder.types.SerializedReferenceType;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.types.SerializerSession;
import net.amygdalum.testrecorder.util.Lambdas;
import net.amygdalum.testrecorder.util.Reflections;
import net.amygdalum.testrecorder.util.Types;

public class DefaultSerializerSession
implements SerializerSession {
    private Map<Object, SerializedValue> serialized = new IdentityHashMap<Object, SerializedValue>();
    private Map<Class<?>, Profile> profiles = new LinkedHashMap();
    private List<Classes> classExclusions;
    private List<Classes> classFacades;
    private List<Fields> fieldExclusions;
    private List<Fields> fieldFacades;
    private Map<Object, Object> facaded = new IdentityHashMap<Object, Object>();

    public DefaultSerializerSession() {
        this.classExclusions = new ArrayList<Classes>();
        this.classFacades = new ArrayList<Classes>();
        this.fieldExclusions = new ArrayList<Fields>();
        this.fieldFacades = new ArrayList<Fields>();
    }

    public DefaultSerializerSession withClassExclusions(List<Classes> classExclusions) {
        this.classExclusions.addAll(classExclusions);
        return this;
    }

    public DefaultSerializerSession withClassFacades(List<Classes> classFacades) {
        this.classFacades.addAll(classFacades);
        return this;
    }

    public DefaultSerializerSession withFieldExclusions(List<Fields> fieldExclusions) {
        this.fieldExclusions.addAll(fieldExclusions);
        return this;
    }

    public DefaultSerializerSession withFieldFacades(List<Fields> fieldFacades) {
        this.fieldFacades.addAll(fieldFacades);
        return this;
    }

    @Override
    public synchronized Profile log(Type type) {
        return this.profiles.computeIfAbsent(Types.baseType((Type)type), t -> Profile.start(t));
    }

    @Override
    public synchronized List<Profile> dumpProfiles() {
        List<Profile> dump = this.profiles.values().stream().sorted().limit(20L).collect(Collectors.toList());
        this.profiles = new LinkedHashMap();
        return dump;
    }

    @Override
    public SerializedValue find(Object object) {
        return this.serialized.get(object);
    }

    @Override
    public SerializedValue ref(Object object, Type type) {
        SerializedValue serializedValue = this.find(object);
        if (serializedValue instanceof SerializedReferenceType && type != null && !Types.baseType((Type)type).isSynthetic()) {
            SerializedReferenceType serializedReferenceType = (SerializedReferenceType)serializedValue;
            serializedReferenceType.useAs(Types.serializableOf((Type)type));
        }
        return serializedValue;
    }

    @Override
    public void resolve(Object object, SerializedValue value) {
        this.serialized.put(object, value);
    }

    @Override
    public boolean excludes(Field field) {
        if (field.isAnnotationPresent(Excluded.class)) {
            return true;
        }
        boolean excluded = this.fieldExclusions.stream().anyMatch(exclusion -> exclusion.matches(field));
        if (!excluded) {
            Class<?> type = field.getType();
            excluded = this.classExclusions.stream().anyMatch(exclusion -> exclusion.matches(type));
        }
        return excluded;
    }

    @Override
    public AnalyzedObject analyze(Object object) {
        if (object == null) {
            return new AnalyzedObject(null);
        }
        Class<?> clazz = object.getClass();
        if (Types.isLiteral(clazz)) {
            return new AnalyzedObject(clazz, object);
        }
        if (Lambdas.isSerializableLambda(clazz)) {
            SerializedLambda lambda = Lambdas.serializeLambda((Object)object);
            Class type = ByteCode.classFrom((String)lambda.getFunctionalInterfaceClass(), (ClassLoader)clazz.getClassLoader());
            return new AnalyzedObject(object, type, lambda);
        }
        if (this.facades(clazz)) {
            this.facaded.put(object, object);
        }
        for (Class<?> objectClass = clazz; objectClass != Object.class; objectClass = objectClass.getSuperclass()) {
            for (Field field : objectClass.getDeclaredFields()) {
                if (!this.facades(field)) continue;
                try {
                    Object obj = Reflections.accessing((AccessibleObject)field).call(f -> f.get(object));
                    this.facaded.put(obj, obj);
                }
                catch (ReflectiveOperationException e) {
                    // empty catch block
                }
            }
        }
        return new AnalyzedObject(clazz, object);
    }

    private boolean facades(Field field) {
        if (field.isAnnotationPresent(Facade.class)) {
            return true;
        }
        return this.fieldFacades.stream().anyMatch(facade -> facade.matches(field));
    }

    private boolean facades(Class<?> clazz) {
        if (clazz.isAnnotationPresent(Facade.class)) {
            return true;
        }
        return this.classFacades.stream().anyMatch(facade -> facade.matches(clazz));
    }

    @Override
    public boolean excludes(Class<?> clazz) {
        if (clazz.isAnnotationPresent(Excluded.class)) {
            return true;
        }
        return this.classExclusions.stream().anyMatch(exclusion -> exclusion.matches(clazz));
    }

    @Override
    public boolean facades(Object object) {
        return this.facaded.containsKey(object);
    }
}

