/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.amygdalum.testrecorder.asm.ByteCode;
import net.amygdalum.testrecorder.types.SerializationException;
import net.amygdalum.testrecorder.util.Types;

public class GlobalContext {
    private List<FieldDescriptor> globals = new ArrayList<FieldDescriptor>();
    private Map<ClassLoader, List<Field>> globalFields = new IdentityHashMap<ClassLoader, List<Field>>();

    public List<Field> globals(ClassLoader loader) {
        return this.globalFields.computeIfAbsent(loader, this::computeGlobalFields);
    }

    private List<Field> computeGlobalFields(ClassLoader loader) {
        return this.globals.stream().map(descriptor -> descriptor.field(loader)).distinct().collect(Collectors.toList());
    }

    public void add(String className, String fieldName) {
        this.globals.add(new FieldDescriptor(className, fieldName));
    }

    public static class FieldDescriptor {
        public String className;
        public String fieldName;

        public FieldDescriptor(String className, String fieldName) {
            this.className = className;
            this.fieldName = fieldName;
        }

        public Field field(ClassLoader loader) {
            try {
                Class clazz = ByteCode.classFrom((String)this.className, (ClassLoader)loader);
                return Types.getDeclaredField((Class)clazz, (String)this.fieldName);
            }
            catch (ReflectiveOperationException | RuntimeException e) {
                throw new SerializationException(e);
            }
        }
    }
}

