/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IOManager {
    private static final Set<String> NONE = Collections.emptySet();
    private Map<String, Set<String>> in = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> out = new HashMap<String, Set<String>>();

    public void propagate(String name, String superName, List<String> interfaceNames) {
        this.propagate(name, superName, interfaceNames, this.in);
        this.propagate(name, superName, interfaceNames, this.out);
    }

    private void propagate(String name, String superName, List<String> interfaceNames, Map<String, Set<String>> inout) {
        Set propagatedIn = inout.computeIfAbsent(name, key -> new HashSet());
        propagatedIn.addAll((Collection)inout.getOrDefault(superName, NONE));
        for (String interfaceName : interfaceNames) {
            propagatedIn.addAll((Collection)inout.getOrDefault(interfaceName, NONE));
        }
    }

    public void registerInput(String className, String methodName, String methodDesc) {
        this.in.compute(className, (key, value) -> {
            if (value == null) {
                value = new HashSet<String>();
            }
            value.add(methodName + methodDesc);
            return value;
        });
    }

    public boolean isInput(String className, String methodName, String methodDesc) {
        return this.in.getOrDefault(className, NONE).contains(methodName + methodDesc);
    }

    public void registerOutput(String className, String methodName, String methodDesc) {
        this.out.compute(className, (key, value) -> {
            if (value == null) {
                value = new HashSet<String>();
            }
            value.add(methodName + methodDesc);
            return value;
        });
    }

    public boolean isOutput(String className, String methodName, String methodDesc) {
        return this.out.getOrDefault(className, NONE).contains(methodName + methodDesc);
    }
}

