/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder;

import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.fakeio.FakeIO;
import net.amygdalum.testrecorder.runtime.Aspect;
import net.amygdalum.testrecorder.types.Computation;
import net.amygdalum.testrecorder.types.DeserializationException;
import net.amygdalum.testrecorder.types.DeserializerContext;
import net.amygdalum.testrecorder.types.LocalVariableNameGenerator;
import net.amygdalum.testrecorder.types.RoleVisitor;
import net.amygdalum.testrecorder.types.SerializedInput;
import net.amygdalum.testrecorder.types.SerializedInteraction;
import net.amygdalum.testrecorder.types.SerializedOutput;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.types.TypeManager;
import net.amygdalum.testrecorder.util.Literals;
import net.amygdalum.testrecorder.util.Types;

public class MockedInteractions {
    public static final MockedInteractions NONE = new MockedInteractions(null, null, Collections.emptyList(), Collections.emptyList());
    private RoleVisitor<Computation> setup;
    private RoleVisitor<Computation> matcher;
    private Collection<SerializedInput> input;
    private Collection<SerializedOutput> output;
    private List<String> fakeClassVariables;

    public MockedInteractions(RoleVisitor<Computation> setup, RoleVisitor<Computation> matcher, Collection<SerializedInput> setupInput, Collection<SerializedOutput> expectOutput) {
        this.setup = setup;
        this.matcher = matcher;
        this.input = setupInput;
        this.output = expectOutput;
        this.fakeClassVariables = new ArrayList<String>();
    }

    public List<String> prepare(DeserializerContext context) {
        if (this.setup == null || this.matcher == null) {
            return Collections.emptyList();
        }
        if (this.input.isEmpty() && this.output.isEmpty()) {
            return Collections.emptyList();
        }
        LocalVariableNameGenerator locals = context.getLocals();
        TypeManager types = context.getTypes();
        types.registerTypes(new Type[]{FakeIO.class, Aspect.class});
        Map<Class, List<SerializedInteraction>> ioByClass = Stream.concat(this.input.stream(), this.output.stream()).collect(Collectors.groupingBy(SerializedInteraction::getDeclaringClass));
        ArrayList<String> statements = new ArrayList<String>();
        String fakeIOType = types.getRawTypeName((Type)((Object)FakeIO.class));
        for (Map.Entry<Class, List<SerializedInteraction>> entry : ioByClass.entrySet()) {
            Class clazz = entry.getKey();
            List<SerializedInteraction> interactions = entry.getValue();
            String[] fakeArgs = new String[]{types.getRawClass(clazz)};
            if (this.isProxy(clazz)) {
                fakeArgs = (String[])interactions.stream().map(interaction -> context.resolve(interaction.getId())).filter(Optional::isPresent).map(value -> ((SerializedValue)value.get()).accept(this.setup)).peek(computation -> statements.addAll(computation.getStatements())).map(computation -> computation.getValue()).toArray(String[]::new);
            }
            String val = Templates.callMethod(fakeIOType, "fake", fakeArgs);
            LinkedHashMap<String, List> interactionsByAspect = new LinkedHashMap<String, List>();
            for (SerializedInteraction serializedInteraction : interactions) {
                LocalVariableNameGenerator methodParams = new LocalVariableNameGenerator();
                String dummyBody = serializedInteraction.getResultType() == Void.TYPE ? "" : Templates.returnStatement(this.nullValue(serializedInteraction.getResultType()));
                String method = Templates.methodDeclaration("public", types.getRawTypeName(serializedInteraction.getResultType()), serializedInteraction.getMethodName(), Arrays.stream(serializedInteraction.getArgumentTypes()).map(type -> Templates.param(types.getRawTypeName((Type)type), methodParams.fetchName((Type)type))).collect(Collectors.toList()), dummyBody);
                String aspect = Templates.newAnonymousClassInstance(types.getRawTypeName((Type)((Object)Aspect.class)), Collections.emptyList(), method);
                String fake = Templates.callLocalMethod(this.fakeMethod(serializedInteraction), aspect);
                List aspectInteractions = interactionsByAspect.computeIfAbsent(fake, key -> new ArrayList());
                aspectInteractions.add(serializedInteraction);
            }
            ArrayList<String> methods = new ArrayList<String>();
            for (Map.Entry aspectInteractions : interactionsByAspect.entrySet()) {
                String aspect = (String)aspectInteractions.getKey();
                methods.add(aspect);
                for (SerializedInteraction interaction3 : (List)aspectInteractions.getValue()) {
                    Computation resultComputation;
                    RoleVisitor<Computation> deserializer = this.deserializerFor(interaction3, this.setup, this.matcher);
                    ArrayList<String> arguments = new ArrayList<String>();
                    if (!interaction3.isStatic()) {
                        Optional<SerializedValue> value2 = context.resolve(interaction3.getId());
                        if (value2.isPresent()) {
                            Computation selfComputation = value2.get().accept(this.setup);
                            statements.addAll(selfComputation.getStatements());
                            arguments.add(selfComputation.getValue());
                        } else {
                            arguments.add(Literals.asLiteral((Object)interaction3.getId()));
                        }
                    }
                    if (interaction3.hasResult()) {
                        resultComputation = interaction3.getResult().accept(this.setup);
                        statements.addAll(resultComputation.getStatements());
                        arguments.add(resultComputation.getValue());
                    } else {
                        resultComputation = Computation.variable("null", interaction3.getResultType());
                        arguments.add(resultComputation.getValue());
                    }
                    List<Computation> argumentsComputation = Arrays.stream(interaction3.getArguments()).map(argument -> (Computation)argument.accept(deserializer)).collect(Collectors.toList());
                    argumentsComputation.forEach(argumentComputation -> {
                        statements.addAll(argumentComputation.getStatements());
                        arguments.add(argumentComputation.getValue());
                    });
                    if (interaction3.isStatic()) {
                        methods.add(Templates.callLocalMethod("addStatic", arguments));
                        continue;
                    }
                    if (context.resolve(interaction3.getId()).isPresent()) {
                        methods.add(Templates.callLocalMethod("addVirtual", arguments));
                        continue;
                    }
                    methods.add(Templates.callLocalMethod("addFreeVirtual", arguments));
                }
            }
            val = Templates.callMethodChainExpression(val, methods);
            String string = locals.fetchName(clazz);
            this.fakeClassVariables.add(string);
            statements.add(Templates.assignLocalVariableStatement(fakeIOType, string, Templates.callMethod(val, "setup", new String[0])));
        }
        return statements;
    }

    private boolean isProxy(Class<?> clazz) {
        return Proxy.isProxyClass(clazz) || clazz == Proxy.class;
    }

    private RoleVisitor<Computation> deserializerFor(SerializedInteraction interaction, RoleVisitor<Computation> setup, RoleVisitor<Computation> matcher) {
        if (interaction instanceof SerializedInput) {
            return setup;
        }
        if (interaction instanceof SerializedOutput) {
            return matcher;
        }
        throw new DeserializationException("unknown faking: " + interaction.getClass());
    }

    private String fakeMethod(SerializedInteraction interaction) {
        if (interaction instanceof SerializedInput) {
            return "fakeInput";
        }
        if (interaction instanceof SerializedOutput) {
            return "fakeOutput";
        }
        throw new DeserializationException("unknown faking: " + interaction.getClass());
    }

    private String nullValue(Type type) {
        if (!Types.isPrimitive((Type)type)) {
            return "null";
        }
        if (type == Boolean.TYPE) {
            return "false";
        }
        if (type == Character.TYPE) {
            return "(char) 0";
        }
        if (type == Byte.TYPE || type == Short.TYPE || type == Integer.TYPE || type == Long.TYPE) {
            return "0";
        }
        if (type == Float.TYPE || type == Double.TYPE) {
            return "0.0f";
        }
        return "null";
    }

    public List<String> verify(LocalVariableNameGenerator locals, TypeManager types, DeserializerContext context) {
        ArrayList<String> statements = new ArrayList<String>();
        for (String fakeClassVariable : this.fakeClassVariables) {
            statements.add(Templates.callMethodStatement(fakeClassVariable, "verify", new String[0]));
        }
        return statements;
    }
}

