/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder;

import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Type;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.amygdalum.testrecorder.ClassNodeManager;
import net.amygdalum.testrecorder.IOManager;
import net.amygdalum.testrecorder.SnapshotManager;
import net.amygdalum.testrecorder.asm.Assign;
import net.amygdalum.testrecorder.asm.ByteCode;
import net.amygdalum.testrecorder.asm.CaptureCall;
import net.amygdalum.testrecorder.asm.GetClass;
import net.amygdalum.testrecorder.asm.GetInvokedMethodArgumentTypes;
import net.amygdalum.testrecorder.asm.GetInvokedMethodName;
import net.amygdalum.testrecorder.asm.GetInvokedMethodResultType;
import net.amygdalum.testrecorder.asm.GetStatic;
import net.amygdalum.testrecorder.asm.GetThisOrClass;
import net.amygdalum.testrecorder.asm.GetThisOrNull;
import net.amygdalum.testrecorder.asm.InvokeStatic;
import net.amygdalum.testrecorder.asm.InvokeVirtual;
import net.amygdalum.testrecorder.asm.Ldc;
import net.amygdalum.testrecorder.asm.MemoizeBoxed;
import net.amygdalum.testrecorder.asm.MethodContext;
import net.amygdalum.testrecorder.asm.Recall;
import net.amygdalum.testrecorder.asm.Sequence;
import net.amygdalum.testrecorder.asm.SequenceInstruction;
import net.amygdalum.testrecorder.asm.WrapArgumentTypes;
import net.amygdalum.testrecorder.asm.WrapArguments;
import net.amygdalum.testrecorder.asm.WrapMethod;
import net.amygdalum.testrecorder.asm.WrapResultType;
import net.amygdalum.testrecorder.asm.WrapWithTryCatch;
import net.amygdalum.testrecorder.bridge.BridgedSnapshotManager;
import net.amygdalum.testrecorder.profile.AgentConfiguration;
import net.amygdalum.testrecorder.profile.Classes;
import net.amygdalum.testrecorder.profile.Fields;
import net.amygdalum.testrecorder.profile.Global;
import net.amygdalum.testrecorder.profile.Input;
import net.amygdalum.testrecorder.profile.Methods;
import net.amygdalum.testrecorder.profile.Output;
import net.amygdalum.testrecorder.profile.Recorded;
import net.amygdalum.testrecorder.profile.SerializationProfile;
import net.amygdalum.testrecorder.util.AttachableClassFileTransformer;
import net.amygdalum.testrecorder.util.Logger;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class SnapshotInstrumentor
extends AttachableClassFileTransformer
implements ClassFileTransformer {
    private AgentConfiguration config;
    private SerializationProfile profile;
    private ClassNodeManager classes = new ClassNodeManager();
    private IOManager io = new IOManager();
    private Map<String, ClassLoader> instrumentedClassPrototypes;
    private Set<Class<?>> instrumentedClasses;

    public SnapshotInstrumentor(AgentConfiguration config) {
        this.config = config;
        this.profile = config.loadConfiguration(SerializationProfile.class, new Object[0]);
        this.classes = new ClassNodeManager();
        this.instrumentedClassPrototypes = new LinkedHashMap<String, ClassLoader>();
        this.instrumentedClasses = new LinkedHashSet();
    }

    public AttachableClassFileTransformer attach(Instrumentation inst) {
        this.initialize(inst);
        return super.attach(inst);
    }

    protected void initialize(Instrumentation inst) {
        SnapshotManager.init(this.config, inst);
    }

    public void detach(Instrumentation inst) {
        super.detach(inst);
        this.shutdown(inst);
    }

    protected void shutdown(Instrumentation inst) {
        SnapshotManager.done(this.config, inst);
    }

    public Collection<Class<?>> filterClassesToRetransform(Class<?>[] loaded) {
        LinkedHashSet classesToRetransform = new LinkedHashSet();
        for (Class<?> clazz : loaded) {
            for (Classes classes : this.profile.getClasses()) {
                if (!classes.matches(clazz)) continue;
                classesToRetransform.add(clazz);
            }
        }
        return classesToRetransform;
    }

    public Collection<Class<?>> getClassesToRetransform() {
        LinkedHashSet classesToRetransform = new LinkedHashSet();
        classesToRetransform.addAll(this.instrumentedClasses);
        for (Map.Entry<String, ClassLoader> classPrototype : this.instrumentedClassPrototypes.entrySet()) {
            classesToRetransform.add(ByteCode.classFrom((String)classPrototype.getKey(), (ClassLoader)classPrototype.getValue()));
        }
        return classesToRetransform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        boolean aquired = this.lock.acquire();
        if (!aquired) {
            return null;
        }
        try {
            if (className == null) {
                byte[] byArray = null;
                return byArray;
            }
            for (Classes clazz : this.profile.getClasses()) {
                if (!clazz.matches(className)) continue;
                Logger.info((Object[])new Object[]{"recording snapshots of " + className});
                byte[] instrument = this.instrument(classfileBuffer, classBeingRedefined, loader);
                if (classBeingRedefined != null) {
                    this.instrumentedClasses.add(classBeingRedefined);
                    this.instrumentedClassPrototypes.remove(org.objectweb.asm.Type.getObjectType((String)classBeingRedefined.getName()).getClassName());
                } else {
                    this.instrumentedClassPrototypes.put(className, loader);
                }
                byte[] byArray = instrument;
                return byArray;
            }
            Iterator<Classes> iterator = null;
            return iterator;
        }
        catch (Throwable e) {
            Logger.error((Object[])new Object[]{"exception occured while preparing recording of snapshots: ", e});
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.lock.release();
        }
    }

    public byte[] instrument(String className, Class<?> clazz, ClassLoader loader) throws IOException {
        return this.instrument(this.classes.fetch(className, loader), clazz, loader);
    }

    public byte[] instrument(byte[] buffer, Class<?> clazz, ClassLoader loader) {
        return this.instrument(this.classes.register(buffer), clazz, loader);
    }

    public byte[] instrument(ClassNode classNode, Class<?> clazz, ClassLoader loader) {
        this.analyzeMethods(classNode);
        if (!this.isClass(classNode)) {
            return null;
        }
        Task task = this.needsBridging(classNode, clazz) ? new BridgedTask(loader, this.profile, this.classes, this.io, classNode) : new DefaultTask(loader, this.profile, this.classes, this.io, classNode);
        task.logSkippedSnapshotMethods();
        task.registerCallbacks();
        task.instrumentSnapshotMethods();
        task.instrumentInputMethods();
        task.instrumentOutputMethods();
        task.instrumentNativeInputCalls();
        task.instrumentNativeOutputCalls();
        ClassWriter out = new ClassWriter(3);
        classNode.accept((ClassVisitor)out);
        return out.toByteArray();
    }

    private void analyzeMethods(ClassNode classNode) {
        for (MethodNode methodNode : classNode.methods) {
            this.analyzeMethod(classNode, methodNode);
        }
    }

    private void analyzeMethod(ClassNode classNode, MethodNode methodNode) {
        if (SnapshotInstrumentor.annotations(methodNode).stream().anyMatch(annotation -> annotation.desc.equals(org.objectweb.asm.Type.getDescriptor(Input.class)))) {
            this.io.registerInput(classNode.name, methodNode.name, methodNode.desc);
        }
        if (SnapshotInstrumentor.annotations(methodNode).stream().anyMatch(annotation -> annotation.desc.equals(org.objectweb.asm.Type.getDescriptor(Output.class)))) {
            this.io.registerOutput(classNode.name, methodNode.name, methodNode.desc);
        }
    }

    private boolean isClass(ClassNode classNode) {
        return (classNode.access & 0x2200) == 0;
    }

    private boolean needsBridging(ClassNode classNode, Class<?> clazz) {
        return clazz != null && clazz.getClassLoader() == null;
    }

    private static List<AnnotationNode> annotations(FieldNode node) {
        if (node.visibleAnnotations == null) {
            return Collections.emptyList();
        }
        return node.visibleAnnotations;
    }

    private static List<AnnotationNode> annotations(MethodNode node) {
        if (node.visibleAnnotations == null) {
            return Collections.emptyList();
        }
        return node.visibleAnnotations;
    }

    public static class DefaultTask
    extends Task {
        public DefaultTask(ClassLoader loader, SerializationProfile profile, ClassNodeManager classes, IOManager io, ClassNode classNode) {
            super(loader, profile, classes, io, classNode);
        }

        @Override
        protected SequenceInstruction setupVariables(MethodNode methodNode) {
            return new InvokeVirtual(SnapshotManager.class, "setupVariables", new Class[]{Class.class, Object.class, String.class, Object[].class}).withBase((SequenceInstruction)new GetStatic(SnapshotManager.class, "MANAGER")).withArgument(0, (SequenceInstruction)new GetClass()).withArgument(1, (SequenceInstruction)new GetThisOrNull()).withArgument(2, (SequenceInstruction)new Ldc(this.keySignature(this.classNode, methodNode))).withArgument(3, (SequenceInstruction)new WrapArguments());
        }

        @Override
        protected SequenceInstruction expectVariables(MethodNode methodNode) {
            if (ByteCode.returnsResult((MethodNode)methodNode)) {
                return Sequence.start().then((SequenceInstruction)new MemoizeBoxed("returnValue", org.objectweb.asm.Type.getReturnType((String)methodNode.desc))).then((SequenceInstruction)new InvokeVirtual(SnapshotManager.class, "expectVariables", new Class[]{Object.class, String.class, Object.class, Object[].class}).withBase((SequenceInstruction)new GetStatic(SnapshotManager.class, "MANAGER")).withArgument(0, (SequenceInstruction)new GetThisOrNull()).withArgument(1, (SequenceInstruction)new Ldc(this.keySignature(this.classNode, methodNode))).withArgument(2, (SequenceInstruction)new Recall("returnValue")).withArgument(3, (SequenceInstruction)new WrapArguments()));
            }
            return Sequence.start().then((SequenceInstruction)new InvokeVirtual(SnapshotManager.class, "expectVariables", new Class[]{Object.class, String.class, Object[].class}).withBase((SequenceInstruction)new GetStatic(SnapshotManager.class, "MANAGER")).withArgument(0, (SequenceInstruction)new GetThisOrNull()).withArgument(1, (SequenceInstruction)new Ldc(this.keySignature(this.classNode, methodNode))).withArgument(2, (SequenceInstruction)new WrapArguments()));
        }

        @Override
        protected SequenceInstruction throwVariables(MethodNode methodNode) {
            return Sequence.start().then((SequenceInstruction)new MemoizeBoxed("throwable", org.objectweb.asm.Type.getType(Throwable.class))).then((SequenceInstruction)new InvokeVirtual(SnapshotManager.class, "throwVariables", new Class[]{Throwable.class, Object.class, String.class, Object[].class}).withBase((SequenceInstruction)new GetStatic(SnapshotManager.class, "MANAGER")).withArgument(0, (SequenceInstruction)new Recall("throwable")).withArgument(1, (SequenceInstruction)new GetThisOrNull()).withArgument(2, (SequenceInstruction)new Ldc(this.keySignature(this.classNode, methodNode))).withArgument(3, (SequenceInstruction)new WrapArguments()));
        }

        @Override
        protected SequenceInstruction inputVariables(MethodNode methodNode) {
            return new Assign("inputId", org.objectweb.asm.Type.INT_TYPE).value((SequenceInstruction)new InvokeVirtual(SnapshotManager.class, "inputVariables", new Class[]{Object.class, String.class, Type.class, Type[].class}).withBase((SequenceInstruction)new GetStatic(SnapshotManager.class, "MANAGER")).withArgument(0, (SequenceInstruction)new GetThisOrClass()).withArgument(1, (SequenceInstruction)new Ldc(methodNode.name)).withArgument(2, (SequenceInstruction)new WrapResultType()).withArgument(3, (SequenceInstruction)new WrapArgumentTypes()));
        }

        @Override
        protected SequenceInstruction inputArgumentsAndResult(MethodNode methodNode) {
            if (ByteCode.returnsResult((MethodNode)methodNode)) {
                return Sequence.start().then((SequenceInstruction)new MemoizeBoxed("returnValue", org.objectweb.asm.Type.getReturnType((String)methodNode.desc))).then((SequenceInstruction)new InvokeVirtual(SnapshotManager.class, "inputArguments", new Class[]{Integer.TYPE, Object[].class}).withBase((SequenceInstruction)new GetStatic(SnapshotManager.class, "MANAGER")).withArgument(0, (SequenceInstruction)new Recall("inputId")).withArgument(1, (SequenceInstruction)new WrapArguments())).then((SequenceInstruction)new InvokeVirtual(SnapshotManager.class, "inputResult", new Class[]{Integer.TYPE, Object.class}).withBase((SequenceInstruction)new GetStatic(SnapshotManager.class, "MANAGER")).withArgument(0, (SequenceInstruction)new Recall("inputId")).withArgument(1, (SequenceInstruction)new Recall("returnValue")));
            }
            return Sequence.start().then((SequenceInstruction)new InvokeVirtual(SnapshotManager.class, "inputArguments", new Class[]{Integer.TYPE, Object[].class}).withBase((SequenceInstruction)new GetStatic(SnapshotManager.class, "MANAGER")).withArgument(0, (SequenceInstruction)new Recall("inputId")).withArgument(1, (SequenceInstruction)new WrapArguments())).then((SequenceInstruction)new InvokeVirtual(SnapshotManager.class, "inputVoidResult", new Class[]{Integer.TYPE}).withBase((SequenceInstruction)new GetStatic(SnapshotManager.class, "MANAGER")).withArgument(0, (SequenceInstruction)new Recall("inputId")));
        }

        @Override
        protected SequenceInstruction outputVariables(MethodNode methodNode) {
            return Sequence.start().then((SequenceInstruction)new Assign("outputId", org.objectweb.asm.Type.INT_TYPE).value((SequenceInstruction)new InvokeVirtual(SnapshotManager.class, "outputVariables", new Class[]{Object.class, String.class, Type.class, Type[].class}).withBase((SequenceInstruction)new GetStatic(SnapshotManager.class, "MANAGER")).withArgument(0, (SequenceInstruction)new GetThisOrClass()).withArgument(1, (SequenceInstruction)new Ldc(methodNode.name)).withArgument(2, (SequenceInstruction)new WrapResultType()).withArgument(3, (SequenceInstruction)new WrapArgumentTypes()))).then((SequenceInstruction)new InvokeVirtual(SnapshotManager.class, "outputArguments", new Class[]{Integer.TYPE, Object[].class}).withBase((SequenceInstruction)new GetStatic(SnapshotManager.class, "MANAGER")).withArgument(0, (SequenceInstruction)new Recall("outputId")).withArgument(1, (SequenceInstruction)new WrapArguments()));
        }

        @Override
        protected SequenceInstruction outputResult(MethodNode methodNode) {
            if (ByteCode.returnsResult((MethodNode)methodNode)) {
                return Sequence.start().then((SequenceInstruction)new MemoizeBoxed("returnValue", org.objectweb.asm.Type.getReturnType((String)methodNode.desc))).then((SequenceInstruction)new InvokeVirtual(SnapshotManager.class, "outputResult", new Class[]{Integer.TYPE, Object.class}).withBase((SequenceInstruction)new GetStatic(SnapshotManager.class, "MANAGER")).withArgument(0, (SequenceInstruction)new Recall("outputId")).withArgument(1, (SequenceInstruction)new Recall("returnValue")));
            }
            return Sequence.start().then((SequenceInstruction)new InvokeVirtual(SnapshotManager.class, "outputVoidResult", new Class[]{Integer.TYPE}).withBase((SequenceInstruction)new GetStatic(SnapshotManager.class, "MANAGER")).withArgument(0, (SequenceInstruction)new Recall("outputId")));
        }

        @Override
        protected InsnList beforeNativeInputCall(MethodContext context, MethodInsnNode inputCall) {
            return Sequence.start().then((SequenceInstruction)new CaptureCall(inputCall, "base", "arguments")).then((SequenceInstruction)new Assign("inputId", org.objectweb.asm.Type.INT_TYPE).value((SequenceInstruction)new InvokeVirtual(SnapshotManager.class, "inputVariables", new Class[]{Object.class, String.class, Type.class, Type[].class}).withBase((SequenceInstruction)new GetStatic(SnapshotManager.class, "MANAGER")).withArgument(0, (SequenceInstruction)new Recall("base")).withArgument(1, (SequenceInstruction)new GetInvokedMethodName(inputCall)).withArgument(2, (SequenceInstruction)new GetInvokedMethodResultType(inputCall)).withArgument(3, (SequenceInstruction)new GetInvokedMethodArgumentTypes(inputCall)))).build(context);
        }

        @Override
        protected InsnList afterNativeInputCall(MethodContext context, MethodInsnNode inputCall) {
            if (ByteCode.returnsResult((MethodInsnNode)inputCall)) {
                return Sequence.start().then((SequenceInstruction)new MemoizeBoxed("returnValue", org.objectweb.asm.Type.getReturnType((String)inputCall.desc))).then((SequenceInstruction)new InvokeVirtual(SnapshotManager.class, "inputArguments", new Class[]{Integer.TYPE, Object[].class}).withBase((SequenceInstruction)new GetStatic(SnapshotManager.class, "MANAGER")).withArgument(0, (SequenceInstruction)new Recall("inputId")).withArgument(1, (SequenceInstruction)new Recall("arguments"))).then((SequenceInstruction)new InvokeVirtual(SnapshotManager.class, "inputResult", new Class[]{Integer.TYPE, Object.class}).withBase((SequenceInstruction)new GetStatic(SnapshotManager.class, "MANAGER")).withArgument(0, (SequenceInstruction)new Recall("inputId")).withArgument(1, (SequenceInstruction)new Recall("returnValue"))).build(context);
            }
            return Sequence.start().then((SequenceInstruction)new InvokeVirtual(SnapshotManager.class, "inputArguments", new Class[]{Integer.TYPE, Object[].class}).withBase((SequenceInstruction)new GetStatic(SnapshotManager.class, "MANAGER")).withArgument(0, (SequenceInstruction)new Recall("inputId")).withArgument(1, (SequenceInstruction)new Recall("arguments"))).then((SequenceInstruction)new InvokeVirtual(SnapshotManager.class, "inputVoidResult", new Class[]{Integer.TYPE}).withBase((SequenceInstruction)new GetStatic(SnapshotManager.class, "MANAGER")).withArgument(0, (SequenceInstruction)new Recall("inputId"))).build(context);
        }

        @Override
        protected InsnList beforeNativeOutputCall(MethodContext context, MethodInsnNode outputCall) {
            return Sequence.start().then((SequenceInstruction)new CaptureCall(outputCall, "base", "arguments")).then((SequenceInstruction)new Assign("outputId", org.objectweb.asm.Type.INT_TYPE).value((SequenceInstruction)new InvokeVirtual(SnapshotManager.class, "outputVariables", new Class[]{Object.class, String.class, Type.class, Type[].class}).withBase((SequenceInstruction)new GetStatic(SnapshotManager.class, "MANAGER")).withArgument(0, (SequenceInstruction)new Recall("base")).withArgument(1, (SequenceInstruction)new GetInvokedMethodName(outputCall)).withArgument(2, (SequenceInstruction)new GetInvokedMethodResultType(outputCall)).withArgument(3, (SequenceInstruction)new GetInvokedMethodArgumentTypes(outputCall)))).then((SequenceInstruction)new InvokeVirtual(SnapshotManager.class, "outputArguments", new Class[]{Integer.TYPE, Object[].class}).withBase((SequenceInstruction)new GetStatic(SnapshotManager.class, "MANAGER")).withArgument(0, (SequenceInstruction)new Recall("outputId")).withArgument(1, (SequenceInstruction)new Recall("arguments"))).build(context);
        }

        @Override
        protected InsnList afterNativeOutputCall(MethodContext context, MethodInsnNode outputCall) {
            if (ByteCode.returnsResult((MethodInsnNode)outputCall)) {
                return Sequence.start().then((SequenceInstruction)new MemoizeBoxed("returnValue", org.objectweb.asm.Type.getReturnType((String)outputCall.desc))).then((SequenceInstruction)new InvokeVirtual(SnapshotManager.class, "outputResult", new Class[]{Integer.TYPE, Object.class}).withBase((SequenceInstruction)new GetStatic(SnapshotManager.class, "MANAGER")).withArgument(0, (SequenceInstruction)new Recall("outputId")).withArgument(1, (SequenceInstruction)new Recall("returnValue"))).build(context);
            }
            return Sequence.start().then((SequenceInstruction)new InvokeVirtual(SnapshotManager.class, "outputVoidResult", new Class[]{Integer.TYPE}).withBase((SequenceInstruction)new GetStatic(SnapshotManager.class, "MANAGER")).withArgument(0, (SequenceInstruction)new Recall("outputId"))).build(context);
        }
    }

    public static class BridgedTask
    extends Task {
        public BridgedTask(ClassLoader loader, SerializationProfile profile, ClassNodeManager classes, IOManager io, ClassNode classNode) {
            super(loader, profile, classes, io, classNode);
        }

        @Override
        protected SequenceInstruction setupVariables(MethodNode methodNode) {
            return new InvokeStatic(BridgedSnapshotManager.class, "setupVariables", new Class[]{Class.class, Object.class, String.class, Object[].class}).withArgument(0, (SequenceInstruction)new GetClass()).withArgument(1, (SequenceInstruction)new GetThisOrNull()).withArgument(2, (SequenceInstruction)new Ldc(this.keySignature(this.classNode, methodNode))).withArgument(3, (SequenceInstruction)new WrapArguments());
        }

        @Override
        protected SequenceInstruction expectVariables(MethodNode methodNode) {
            if (ByteCode.returnsResult((MethodNode)methodNode)) {
                return Sequence.start().then((SequenceInstruction)new MemoizeBoxed("returnValue", org.objectweb.asm.Type.getReturnType((String)methodNode.desc))).then((SequenceInstruction)new InvokeStatic(BridgedSnapshotManager.class, "expectVariables", new Class[]{Object.class, String.class, Object.class, Object[].class}).withArgument(0, (SequenceInstruction)new GetThisOrNull()).withArgument(1, (SequenceInstruction)new Ldc(this.keySignature(this.classNode, methodNode))).withArgument(2, (SequenceInstruction)new Recall("returnValue")).withArgument(3, (SequenceInstruction)new WrapArguments()));
            }
            return Sequence.start().then((SequenceInstruction)new InvokeStatic(BridgedSnapshotManager.class, "expectVariables", new Class[]{Object.class, String.class, Object[].class}).withArgument(0, (SequenceInstruction)new GetThisOrNull()).withArgument(1, (SequenceInstruction)new Ldc(this.keySignature(this.classNode, methodNode))).withArgument(2, (SequenceInstruction)new WrapArguments()));
        }

        @Override
        protected SequenceInstruction throwVariables(MethodNode methodNode) {
            return Sequence.start().then((SequenceInstruction)new MemoizeBoxed("throwable", org.objectweb.asm.Type.getType(Throwable.class))).then((SequenceInstruction)new InvokeStatic(BridgedSnapshotManager.class, "throwVariables", new Class[]{Throwable.class, Object.class, String.class, Object[].class}).withArgument(0, (SequenceInstruction)new Recall("throwable")).withArgument(1, (SequenceInstruction)new GetThisOrNull()).withArgument(2, (SequenceInstruction)new Ldc(this.keySignature(this.classNode, methodNode))).withArgument(3, (SequenceInstruction)new WrapArguments()));
        }

        @Override
        protected SequenceInstruction inputVariables(MethodNode methodNode) {
            return new Assign("inputId", org.objectweb.asm.Type.INT_TYPE).value((SequenceInstruction)new InvokeStatic(BridgedSnapshotManager.class, "inputVariables", new Class[]{Object.class, String.class, Type.class, Type[].class}).withArgument(0, (SequenceInstruction)new GetThisOrClass()).withArgument(1, (SequenceInstruction)new Ldc(methodNode.name)).withArgument(2, (SequenceInstruction)new WrapResultType()).withArgument(3, (SequenceInstruction)new WrapArgumentTypes()));
        }

        @Override
        protected SequenceInstruction inputArgumentsAndResult(MethodNode methodNode) {
            if (ByteCode.returnsResult((MethodNode)methodNode)) {
                return Sequence.start().then((SequenceInstruction)new MemoizeBoxed("returnValue", org.objectweb.asm.Type.getReturnType((String)methodNode.desc))).then((SequenceInstruction)new InvokeStatic(BridgedSnapshotManager.class, "inputArguments", new Class[]{Integer.TYPE, Object[].class}).withArgument(0, (SequenceInstruction)new Recall("inputId")).withArgument(1, (SequenceInstruction)new WrapArguments())).then((SequenceInstruction)new InvokeStatic(BridgedSnapshotManager.class, "inputResult", new Class[]{Integer.TYPE, Object.class}).withArgument(0, (SequenceInstruction)new Recall("inputId")).withArgument(1, (SequenceInstruction)new Recall("returnValue")));
            }
            return Sequence.start().then((SequenceInstruction)new InvokeStatic(BridgedSnapshotManager.class, "inputArguments", new Class[]{Integer.TYPE, Object[].class}).withArgument(0, (SequenceInstruction)new Recall("inputId")).withArgument(1, (SequenceInstruction)new WrapArguments())).then((SequenceInstruction)new InvokeStatic(BridgedSnapshotManager.class, "inputVoidResult", new Class[]{Integer.TYPE}).withArgument(0, (SequenceInstruction)new Recall("inputId")));
        }

        @Override
        protected SequenceInstruction outputVariables(MethodNode methodNode) {
            return Sequence.start().then((SequenceInstruction)new Assign("outputId", org.objectweb.asm.Type.INT_TYPE).value((SequenceInstruction)new InvokeStatic(BridgedSnapshotManager.class, "outputVariables", new Class[]{Object.class, String.class, Type.class, Type[].class}).withArgument(0, (SequenceInstruction)new GetThisOrClass()).withArgument(1, (SequenceInstruction)new Ldc(methodNode.name)).withArgument(2, (SequenceInstruction)new WrapResultType()).withArgument(3, (SequenceInstruction)new WrapArgumentTypes()))).then((SequenceInstruction)new InvokeStatic(BridgedSnapshotManager.class, "outputArguments", new Class[]{Integer.TYPE, Object[].class}).withArgument(0, (SequenceInstruction)new Recall("outputId")).withArgument(1, (SequenceInstruction)new WrapArguments()));
        }

        @Override
        protected SequenceInstruction outputResult(MethodNode methodNode) {
            if (ByteCode.returnsResult((MethodNode)methodNode)) {
                return Sequence.start().then((SequenceInstruction)new MemoizeBoxed("returnValue", org.objectweb.asm.Type.getReturnType((String)methodNode.desc))).then((SequenceInstruction)new InvokeStatic(BridgedSnapshotManager.class, "outputResult", new Class[]{Integer.TYPE, Object.class}).withArgument(0, (SequenceInstruction)new Recall("outputId")).withArgument(1, (SequenceInstruction)new Recall("returnValue")));
            }
            return Sequence.start().then((SequenceInstruction)new InvokeStatic(BridgedSnapshotManager.class, "outputVoidResult", new Class[]{Integer.TYPE}).withArgument(0, (SequenceInstruction)new Recall("outputId")));
        }

        @Override
        protected InsnList beforeNativeInputCall(MethodContext context, MethodInsnNode inputCall) {
            return Sequence.start().then((SequenceInstruction)new CaptureCall(inputCall, "base", "arguments")).then((SequenceInstruction)new Assign("inputId", org.objectweb.asm.Type.INT_TYPE).value((SequenceInstruction)new InvokeStatic(BridgedSnapshotManager.class, "inputVariables", new Class[]{Object.class, String.class, Type.class, Type[].class}).withArgument(0, (SequenceInstruction)new Recall("base")).withArgument(1, (SequenceInstruction)new GetInvokedMethodName(inputCall)).withArgument(2, (SequenceInstruction)new GetInvokedMethodResultType(inputCall)).withArgument(3, (SequenceInstruction)new GetInvokedMethodArgumentTypes(inputCall)))).build(context);
        }

        @Override
        protected InsnList afterNativeInputCall(MethodContext context, MethodInsnNode inputCall) {
            if (ByteCode.returnsResult((MethodInsnNode)inputCall)) {
                return Sequence.start().then((SequenceInstruction)new MemoizeBoxed("returnValue", org.objectweb.asm.Type.getReturnType((String)inputCall.desc))).then((SequenceInstruction)new InvokeStatic(BridgedSnapshotManager.class, "inputArguments", new Class[]{Integer.TYPE, Object[].class}).withArgument(0, (SequenceInstruction)new Recall("inputId")).withArgument(1, (SequenceInstruction)new Recall("arguments"))).then((SequenceInstruction)new InvokeStatic(BridgedSnapshotManager.class, "inputResult", new Class[]{Integer.TYPE, Object.class}).withArgument(0, (SequenceInstruction)new Recall("inputId")).withArgument(1, (SequenceInstruction)new Recall("returnValue"))).build(context);
            }
            return Sequence.start().then((SequenceInstruction)new InvokeStatic(BridgedSnapshotManager.class, "inputArguments", new Class[]{Integer.TYPE, Object[].class}).withArgument(0, (SequenceInstruction)new Recall("inputId")).withArgument(1, (SequenceInstruction)new Recall("arguments"))).then((SequenceInstruction)new InvokeStatic(BridgedSnapshotManager.class, "inputVoidResult", new Class[]{Integer.TYPE}).withArgument(0, (SequenceInstruction)new Recall("inputId"))).build(context);
        }

        @Override
        protected InsnList beforeNativeOutputCall(MethodContext context, MethodInsnNode inputCall) {
            return Sequence.start().then((SequenceInstruction)new CaptureCall(inputCall, "base", "arguments")).then((SequenceInstruction)new Assign("outputId", org.objectweb.asm.Type.INT_TYPE).value((SequenceInstruction)new InvokeStatic(BridgedSnapshotManager.class, "outputVariables", new Class[]{Object.class, String.class, Type.class, Type[].class}).withArgument(0, (SequenceInstruction)new Recall("base")).withArgument(1, (SequenceInstruction)new GetInvokedMethodName(inputCall)).withArgument(2, (SequenceInstruction)new GetInvokedMethodResultType(inputCall)).withArgument(3, (SequenceInstruction)new GetInvokedMethodArgumentTypes(inputCall)))).then((SequenceInstruction)new InvokeStatic(BridgedSnapshotManager.class, "outputArguments", new Class[]{Integer.TYPE, Object[].class}).withArgument(0, (SequenceInstruction)new Recall("outputId")).withArgument(1, (SequenceInstruction)new Recall("arguments"))).build(context);
        }

        @Override
        protected InsnList afterNativeOutputCall(MethodContext context, MethodInsnNode inputCall) {
            if (ByteCode.returnsResult((MethodInsnNode)inputCall)) {
                return Sequence.start().then((SequenceInstruction)new MemoizeBoxed("returnValue", org.objectweb.asm.Type.getReturnType((String)inputCall.desc))).then((SequenceInstruction)new InvokeStatic(BridgedSnapshotManager.class, "outputResult", new Class[]{Integer.TYPE, Object.class}).withArgument(0, (SequenceInstruction)new Recall("outputId")).withArgument(1, (SequenceInstruction)new Recall("returnValue"))).build(context);
            }
            return Sequence.start().then((SequenceInstruction)new InvokeStatic(BridgedSnapshotManager.class, "outputVoidResult", new Class[]{Integer.TYPE}).withArgument(0, (SequenceInstruction)new Recall("outputId"))).build(context);
        }
    }

    public static abstract class Task {
        private ClassLoader loader;
        private SerializationProfile profile;
        private ClassNodeManager classes;
        private IOManager io;
        protected ClassNode classNode;

        public Task(ClassLoader loader, SerializationProfile profile, ClassNodeManager classes, IOManager io, ClassNode classNode) {
            this.loader = loader;
            this.profile = profile;
            this.classes = classes;
            this.io = io;
            this.classNode = classNode;
            io.propagate(classNode.name, classNode.superName, classNode.interfaces);
        }

        public void logSkippedSnapshotMethods() {
            for (MethodNode methodNode : this.getSkippedSnapshotMethods()) {
                Logger.warn((Object[])new Object[]{"method " + org.objectweb.asm.Type.getMethodType((String)methodNode.desc).getDescriptor() + " in " + org.objectweb.asm.Type.getObjectType((String)this.classNode.name) + " is not accessible, skipping"});
            }
        }

        public void registerCallbacks() {
            for (MethodNode methodNode : this.getSnapshotMethods()) {
                SnapshotManager.MANAGER.registerRecordedMethod(this.keySignature(this.classNode, methodNode), this.classNode.name, methodNode.name, methodNode.desc);
            }
            for (FieldNode fieldNode : this.getGlobalFields()) {
                SnapshotManager.MANAGER.registerGlobal(this.classNode.name, fieldNode.name);
            }
        }

        private void instrumentSnapshotMethods() {
            for (MethodNode method : this.getSnapshotMethods()) {
                this.instrumentSnapshotMethod(method);
            }
        }

        protected void instrumentSnapshotMethod(MethodNode methodNode) {
            methodNode.instructions = new WrapWithTryCatch().before(this.setupVariables(methodNode)).after(this.expectVariables(methodNode)).handler(this.throwVariables(methodNode)).build(new MethodContext(this.classNode, methodNode));
        }

        protected abstract SequenceInstruction setupVariables(MethodNode var1);

        protected abstract SequenceInstruction expectVariables(MethodNode var1);

        protected abstract SequenceInstruction throwVariables(MethodNode var1);

        public void instrumentInputMethods() {
            for (MethodNode method : this.getJavaInputMethods()) {
                this.instrumentInputMethod(method);
            }
        }

        protected void instrumentInputMethod(MethodNode methodNode) {
            methodNode.instructions = new WrapMethod().prepend(this.inputVariables(methodNode)).append(this.inputArgumentsAndResult(methodNode)).build(new MethodContext(this.classNode, methodNode));
        }

        protected abstract SequenceInstruction inputArgumentsAndResult(MethodNode var1);

        protected abstract SequenceInstruction inputVariables(MethodNode var1);

        public void instrumentOutputMethods() {
            for (MethodNode method : this.getJavaOutputMethods()) {
                this.instrumentOutputMethod(method);
            }
        }

        protected void instrumentOutputMethod(MethodNode methodNode) {
            methodNode.instructions = new WrapMethod().prepend(this.outputVariables(methodNode)).append(this.outputResult(methodNode)).build(new MethodContext(this.classNode, methodNode));
        }

        protected abstract SequenceInstruction outputVariables(MethodNode var1);

        protected abstract SequenceInstruction outputResult(MethodNode var1);

        private void instrumentNativeInputCalls() {
            for (MethodNode method : this.classNode.methods) {
                if (this.isInputMethod(this.classNode, method)) continue;
                MethodContext context = new MethodContext(this.classNode, method);
                for (MethodInsnNode inputCall : this.getNativeInputCalls(method)) {
                    method.instructions.insertBefore((AbstractInsnNode)inputCall, this.beforeNativeInputCall(context, inputCall));
                    method.instructions.insert((AbstractInsnNode)inputCall, this.afterNativeInputCall(context, inputCall));
                }
            }
        }

        private void instrumentNativeOutputCalls() {
            for (MethodNode method : this.classNode.methods) {
                if (this.isOutputMethod(this.classNode, method)) continue;
                MethodContext context = new MethodContext(this.classNode, method);
                for (MethodInsnNode outputCall : this.getNativeOutputCalls(method)) {
                    method.instructions.insertBefore((AbstractInsnNode)outputCall, this.beforeNativeOutputCall(context, outputCall));
                    method.instructions.insert((AbstractInsnNode)outputCall, this.afterNativeOutputCall(context, outputCall));
                }
            }
        }

        protected abstract InsnList afterNativeInputCall(MethodContext var1, MethodInsnNode var2);

        protected abstract InsnList beforeNativeInputCall(MethodContext var1, MethodInsnNode var2);

        protected abstract InsnList beforeNativeOutputCall(MethodContext var1, MethodInsnNode var2);

        protected abstract InsnList afterNativeOutputCall(MethodContext var1, MethodInsnNode var2);

        private List<MethodNode> getSkippedSnapshotMethods() {
            return this.classNode.methods.stream().filter(methodNode -> this.isSnapshotMethod(this.classNode, (MethodNode)methodNode)).filter(methodNode -> !this.isVisible(this.classNode) || !this.isVisible((MethodNode)methodNode)).collect(Collectors.toList());
        }

        private List<FieldNode> getGlobalFields() {
            if (!this.isVisible(this.classNode)) {
                return Collections.emptyList();
            }
            return this.classNode.fields.stream().filter(field -> this.isGlobalField(this.classNode.name, (FieldNode)field)).filter(field -> this.isVisible((FieldNode)field)).collect(Collectors.toList());
        }

        private List<MethodNode> getSnapshotMethods() {
            if (!this.isVisible(this.classNode)) {
                return Collections.emptyList();
            }
            return this.classNode.methods.stream().filter(methodNode -> this.isSnapshotMethod(this.classNode, (MethodNode)methodNode)).filter(methodNode -> this.isVisible((MethodNode)methodNode)).collect(Collectors.toList());
        }

        private List<MethodNode> getJavaInputMethods() {
            if (!this.isVisible(this.classNode)) {
                return Collections.emptyList();
            }
            return this.classNode.methods.stream().filter(methodNode -> this.isJavaInputMethod(this.classNode, (MethodNode)methodNode)).collect(Collectors.toList());
        }

        private List<MethodNode> getJavaOutputMethods() {
            if (!this.isVisible(this.classNode)) {
                return Collections.emptyList();
            }
            return this.classNode.methods.stream().filter(method -> this.isJavaOutputMethod(this.classNode, (MethodNode)method)).collect(Collectors.toList());
        }

        private List<MethodInsnNode> getNativeInputCalls(MethodNode methodNode) {
            ArrayList<MethodInsnNode> calls = new ArrayList<MethodInsnNode>();
            for (AbstractInsnNode insn : methodNode.instructions) {
                if (!(insn instanceof MethodInsnNode)) continue;
                MethodInsnNode methodinsn = (MethodInsnNode)insn;
                try {
                    MethodNode calledMethodNode;
                    ClassNode calledClassNode;
                    org.objectweb.asm.Type type = org.objectweb.asm.Type.getObjectType((String)methodinsn.owner);
                    if (ByteCode.isPrimitive((org.objectweb.asm.Type)type) || ByteCode.isArray((org.objectweb.asm.Type)type) || !this.isNativeInputMethod(calledClassNode = this.classes.fetch(methodinsn.owner, this.loader), calledMethodNode = this.classes.fetch(calledClassNode, methodinsn.name, methodinsn.desc, this.loader))) continue;
                    calls.add(methodinsn);
                }
                catch (IOException e) {
                    Logger.warn((Object[])new Object[]{"cannot find referenced class " + methodinsn.owner + ", skipping"});
                }
                catch (NoSuchMethodException e) {
                    Logger.warn((Object[])new Object[]{"cannot find referenced method " + methodinsn.owner + "." + methodinsn.name + methodinsn.desc + ", skipping"});
                }
            }
            return calls;
        }

        private List<MethodInsnNode> getNativeOutputCalls(MethodNode methodNode) {
            ArrayList<MethodInsnNode> calls = new ArrayList<MethodInsnNode>();
            for (AbstractInsnNode insn : methodNode.instructions) {
                if (!(insn instanceof MethodInsnNode)) continue;
                MethodInsnNode methodinsn = (MethodInsnNode)insn;
                try {
                    MethodNode calledMethodNode;
                    ClassNode calledClassNode;
                    org.objectweb.asm.Type type = org.objectweb.asm.Type.getObjectType((String)methodinsn.owner);
                    if (ByteCode.isPrimitive((org.objectweb.asm.Type)type) || ByteCode.isArray((org.objectweb.asm.Type)type) || !this.isNativeOutputMethod(calledClassNode = this.classes.fetch(methodinsn.owner, this.loader), calledMethodNode = this.classes.fetch(calledClassNode, methodinsn.name, methodinsn.desc, this.loader))) continue;
                    calls.add(methodinsn);
                }
                catch (IOException e) {
                    Logger.warn((Object[])new Object[]{"cannot find referenced class " + methodinsn.owner + ", skipping"});
                }
                catch (NoSuchMethodException e) {
                    Logger.warn((Object[])new Object[]{"cannot find referenced method " + methodinsn.owner + "." + methodinsn.name + methodinsn.desc + ", skipping"});
                }
            }
            return calls;
        }

        protected boolean isGlobalField(String className, FieldNode fieldNode) {
            boolean global;
            boolean bl = global = SnapshotInstrumentor.annotations(fieldNode).stream().anyMatch(annotation -> annotation.desc.equals(org.objectweb.asm.Type.getDescriptor(Global.class))) || this.profile.getGlobalFields().stream().anyMatch(field -> this.matches((Fields)field, className, fieldNode.name, fieldNode.desc));
            if (global && !ByteCode.isStatic((FieldNode)fieldNode)) {
                Logger.warn((Object[])new Object[]{"found annotation @Global on non static field " + fieldNode.desc + " " + fieldNode.name + ", skipping"});
                return false;
            }
            return global;
        }

        protected boolean isSnapshotMethod(ClassNode classNode, MethodNode methodNode) {
            return SnapshotInstrumentor.annotations(methodNode).stream().anyMatch(annotation -> annotation.desc.equals(org.objectweb.asm.Type.getDescriptor(Recorded.class))) || this.profile.getRecorded().stream().anyMatch(method -> this.matches((Methods)method, classNode.name, methodNode.name, methodNode.desc));
        }

        protected boolean isJavaInputMethod(ClassNode classNode, MethodNode methodNode) {
            return !ByteCode.isNative((MethodNode)methodNode) && this.isInputMethod(classNode, methodNode);
        }

        protected boolean isNativeInputMethod(ClassNode classNode, MethodNode methodNode) {
            return ByteCode.isNative((MethodNode)methodNode) && this.isInputMethod(classNode, methodNode);
        }

        protected boolean isInputMethod(ClassNode classNode, MethodNode methodNode) {
            boolean input = this.isQualifiedInputMethod(classNode, methodNode);
            if (input && (this.isQualifiedOutputMethod(classNode, methodNode) || this.isSnapshotMethod(classNode, methodNode))) {
                Logger.warn((Object[])new Object[]{"found annotation @Input on method already annotated with @Recorded or @Output " + methodNode.name + methodNode.desc + ", skipping"});
                return false;
            }
            return input;
        }

        private boolean isQualifiedInputMethod(ClassNode classNode, MethodNode methodNode) {
            return this.io.isInput(classNode.name, methodNode.name, methodNode.desc) || this.profile.getInputs().stream().anyMatch(method -> this.matches((Methods)method, classNode.name, methodNode.name, methodNode.desc));
        }

        protected boolean isJavaOutputMethod(ClassNode classNode, MethodNode methodNode) {
            return !ByteCode.isNative((MethodNode)methodNode) && this.isOutputMethod(classNode, methodNode);
        }

        protected boolean isNativeOutputMethod(ClassNode classNode, MethodNode methodNode) {
            return ByteCode.isNative((MethodNode)methodNode) && this.isOutputMethod(classNode, methodNode);
        }

        protected boolean isOutputMethod(ClassNode classNode, MethodNode methodNode) {
            boolean output = this.isQualifiedOutputMethod(classNode, methodNode);
            if (output && (this.isQualifiedInputMethod(classNode, methodNode) || this.isSnapshotMethod(classNode, methodNode))) {
                Logger.warn((Object[])new Object[]{"found annotation @Output on method already annotated with @Recorded or @Input " + methodNode.name + methodNode.desc + ", skipping"});
                return false;
            }
            return output;
        }

        private boolean isQualifiedOutputMethod(ClassNode classNode, MethodNode methodNode) {
            return this.io.isOutput(classNode.name, methodNode.name, methodNode.desc) || this.profile.getOutputs().stream().anyMatch(method -> this.matches((Methods)method, classNode.name, methodNode.name, methodNode.desc));
        }

        private boolean isVisible(ClassNode classNode) {
            if ((classNode.access & 2) != 0) {
                return false;
            }
            return classNode.innerClasses.stream().filter(innerClassNode -> innerClassNode.name.equals(classNode.name)).map(innerClassNode -> (innerClassNode.access & 2) == 0).findFirst().orElse(true);
        }

        private boolean isVisible(MethodNode methodNode) {
            return (methodNode.access & 2) == 0;
        }

        private boolean isVisible(FieldNode fieldNode) {
            return (fieldNode.access & 2) == 0;
        }

        private boolean matches(Fields field, String className, String fieldName, String fieldDescriptor) {
            return field.matches(className, fieldName, fieldDescriptor);
        }

        private boolean matches(Methods method, String className, String methodName, String methodDescriptor) {
            return method.matches(className, methodName, methodDescriptor);
        }

        protected String keySignature(ClassNode classNode, MethodNode methodNode) {
            return classNode.name + ":" + methodNode.name + methodNode.desc;
        }
    }
}

