/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder;

import java.lang.instrument.Instrumentation;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.amygdalum.testrecorder.AllLambdasSerializableTransformer;
import net.amygdalum.testrecorder.DefaultPerformanceProfile;
import net.amygdalum.testrecorder.DefaultSerializationProfile;
import net.amygdalum.testrecorder.DefaultSnapshotConsumer;
import net.amygdalum.testrecorder.SnapshotInstrumentor;
import net.amygdalum.testrecorder.profile.AgentConfiguration;
import net.amygdalum.testrecorder.profile.ClassPathConfigurationLoader;
import net.amygdalum.testrecorder.profile.DefaultPathConfigurationLoader;
import net.amygdalum.testrecorder.profile.PathConfigurationLoader;
import net.amygdalum.testrecorder.profile.PerformanceProfile;
import net.amygdalum.testrecorder.profile.SerializationProfile;
import net.amygdalum.testrecorder.profile.SnapshotConsumer;
import net.amygdalum.testrecorder.util.AttachableClassFileTransformer;

public class TestRecorderAgent {
    private Instrumentation inst;
    private AgentConfiguration config;
    private List<Class<? extends AttachableClassFileTransformer>> transformerClasses;
    private Deque<AttachableClassFileTransformer> transformers;

    public TestRecorderAgent(Instrumentation inst, AgentConfiguration config, List<Class<? extends AttachableClassFileTransformer>> transformerClasses) {
        this.inst = inst;
        this.config = config;
        this.transformerClasses = transformerClasses;
    }

    public TestRecorderAgent(Instrumentation inst, AgentConfiguration config) {
        this(inst, config, Arrays.asList(AllLambdasSerializableTransformer.class, SnapshotInstrumentor.class));
    }

    public AgentConfiguration getConfig() {
        return this.config;
    }

    public static void agentmain(String agentArgs, Instrumentation inst) {
        AgentConfiguration config = TestRecorderAgent.loadConfig(agentArgs);
        new TestRecorderAgent(inst, config).prepareInstrumentations();
    }

    public static void premain(String agentArgs, Instrumentation inst) {
        AgentConfiguration config = TestRecorderAgent.loadConfig(agentArgs);
        new TestRecorderAgent(inst, config).prepareInstrumentations();
    }

    protected static AgentConfiguration loadConfig(String agentArgs) {
        if (agentArgs != null) {
            List<Path> paths = Arrays.stream(agentArgs.split(";")).map(path -> Paths.get(path, new String[0])).collect(Collectors.toList());
            return new AgentConfiguration(new PathConfigurationLoader(paths), new ClassPathConfigurationLoader(), new DefaultPathConfigurationLoader()).withDefaultValue(SerializationProfile.class, DefaultSerializationProfile::new).withDefaultValue(PerformanceProfile.class, DefaultPerformanceProfile::new).withDefaultValue(SnapshotConsumer.class, DefaultSnapshotConsumer::new);
        }
        return new AgentConfiguration(new ClassPathConfigurationLoader(), new DefaultPathConfigurationLoader()).withDefaultValue(SerializationProfile.class, DefaultSerializationProfile::new).withDefaultValue(PerformanceProfile.class, DefaultPerformanceProfile::new).withDefaultValue(SnapshotConsumer.class, DefaultSnapshotConsumer::new);
    }

    public void prepareInstrumentations() {
        this.transformers = new LinkedList<AttachableClassFileTransformer>();
        for (Class<? extends AttachableClassFileTransformer> clazz : this.transformerClasses) {
            AttachableClassFileTransformer transformer = this.instantiate(clazz);
            transformer.attach(this.inst);
            this.transformers.add(transformer);
        }
    }

    public AttachableClassFileTransformer instantiate(Class<? extends AttachableClassFileTransformer> clazz) {
        try {
            return clazz.getDeclaredConstructor(AgentConfiguration.class).newInstance(this.config);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            try {
                return clazz.newInstance();
            }
            catch (ReflectiveOperationException reflectiveOperationException2) {
                throw new RuntimeException("failed to instantiate transformer <" + clazz.getName() + ">, tried:\nnew " + clazz.getSimpleName() + "(AgentConfig)\nnew " + clazz.getSimpleName() + "()");
            }
        }
    }

    public void clearInstrumentations() {
        if (this.transformers == null) {
            return;
        }
        while (!this.transformers.isEmpty()) {
            AttachableClassFileTransformer current = this.transformers.removeLast();
            current.detach(this.inst);
        }
    }

    public void withoutInstrumentation(Runnable runnable) {
        try {
            this.clearInstrumentations();
            runnable.run();
        }
        finally {
            this.prepareInstrumentations();
        }
    }
}

