/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.codeserializer;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.amygdalum.testrecorder.ConfigurableSerializerFacade;
import net.amygdalum.testrecorder.DefaultPerformanceProfile;
import net.amygdalum.testrecorder.DefaultSerializationProfile;
import net.amygdalum.testrecorder.DefaultSnapshotConsumer;
import net.amygdalum.testrecorder.deserializers.CustomAnnotation;
import net.amygdalum.testrecorder.deserializers.DefaultDeserializerContext;
import net.amygdalum.testrecorder.deserializers.Deserializer;
import net.amygdalum.testrecorder.deserializers.DeserializerFactory;
import net.amygdalum.testrecorder.deserializers.DeserializerTypeManager;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.builder.SetupGenerators;
import net.amygdalum.testrecorder.generator.DefaultTestGeneratorProfile;
import net.amygdalum.testrecorder.generator.TestGeneratorProfile;
import net.amygdalum.testrecorder.profile.AgentConfiguration;
import net.amygdalum.testrecorder.profile.ClassPathConfigurationLoader;
import net.amygdalum.testrecorder.profile.ConfigurationLoader;
import net.amygdalum.testrecorder.profile.DefaultPathConfigurationLoader;
import net.amygdalum.testrecorder.profile.PerformanceProfile;
import net.amygdalum.testrecorder.profile.SerializationProfile;
import net.amygdalum.testrecorder.profile.SnapshotConsumer;
import net.amygdalum.testrecorder.serializers.SerializerFacade;
import net.amygdalum.testrecorder.types.Computation;
import net.amygdalum.testrecorder.types.LocalVariableNameGenerator;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.types.SerializerSession;
import net.amygdalum.testrecorder.types.TypeManager;

public class CodeSerializer {
    private TestGeneratorProfile generatorProfile;
    private SerializerFacade facade;
    private SerializerSession session;
    private TypeManager types;
    private DeserializerFactory deserializers;

    public CodeSerializer() {
        this("", ConfigurableSerializerFacade::new, SetupGenerators::new);
    }

    public CodeSerializer(String pkg) {
        this(pkg, ConfigurationLoader.defaultClassLoader(CodeSerializer.class), ConfigurableSerializerFacade::new, SetupGenerators::new);
    }

    public CodeSerializer(String pkg, Function<AgentConfiguration, SerializerFacade> facade, Function<AgentConfiguration, DeserializerFactory> deserializers) {
        this(pkg, ConfigurationLoader.defaultClassLoader(CodeSerializer.class), facade, deserializers);
    }

    public CodeSerializer(String pkg, ClassLoader loader, Function<AgentConfiguration, SerializerFacade> facade, Function<AgentConfiguration, DeserializerFactory> deserializers) {
        this(pkg, new AgentConfiguration(new ClassPathConfigurationLoader(loader), new DefaultPathConfigurationLoader(loader)).withDefaultValue(SerializationProfile.class, DefaultSerializationProfile::new).withDefaultValue(PerformanceProfile.class, DefaultPerformanceProfile::new).withDefaultValue(SnapshotConsumer.class, DefaultSnapshotConsumer::new), facade, deserializers);
    }

    public CodeSerializer(String pkg, AgentConfiguration config, Function<AgentConfiguration, SerializerFacade> facade, Function<AgentConfiguration, DeserializerFactory> deserializers) {
        this.generatorProfile = config.loadOptionalConfiguration(TestGeneratorProfile.class, new Object[0]).orElseGet(DefaultTestGeneratorProfile::new);
        this.facade = facade.apply(config);
        this.session = this.facade.newSession();
        this.deserializers = deserializers.apply(config);
        this.types = new DeserializerTypeManager(pkg);
    }

    public TypeManager getTypes() {
        return this.types;
    }

    public String serialize(Object value) {
        return this.serialize(value.getClass(), value);
    }

    public String serialize(Type type, Object value) {
        SerializedValue serializedValue = this.facade.serialize(type, value, this.session);
        return new Generator(serializedValue).generateCode();
    }

    private class Generator {
        private LocalVariableNameGenerator locals;
        private SerializedValue value;
        private List<String> statements;
        private Deserializer deserializer;

        Generator(SerializedValue value) {
            this.value = value;
            this.locals = new LocalVariableNameGenerator();
            this.statements = new ArrayList<String>();
            this.deserializer = CodeSerializer.this.deserializers.newGenerator(this.newContext(this.locals));
        }

        private DefaultDeserializerContext newContext(LocalVariableNameGenerator locals) {
            DefaultDeserializerContext context = new DefaultDeserializerContext(CodeSerializer.this.types, locals);
            for (CustomAnnotation annotation : CodeSerializer.this.generatorProfile.annotations()) {
                context.addHint(annotation.getTarget(), annotation.getAnnotation());
            }
            return context;
        }

        public String generateCode() {
            Computation serialized = this.value.accept(this.deserializer);
            this.statements.addAll(serialized.getStatements());
            if (!serialized.isStored()) {
                String name = this.locals.fetchName(this.value.getClass());
                String type = CodeSerializer.this.types.getVariableTypeName(serialized.getType());
                this.statements.add(Templates.assignLocalVariableStatement(type, name, serialized.getValue()));
            }
            return this.statements.stream().collect(Collectors.joining("\n"));
        }
    }
}

