/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.configurator;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.amygdalum.testrecorder.DefaultPerformanceProfile;
import net.amygdalum.testrecorder.DefaultSerializationProfile;
import net.amygdalum.testrecorder.DefaultSnapshotConsumer;
import net.amygdalum.testrecorder.deserializers.builder.ArraysListAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.BeanObjectAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.CollectionsListAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.CollectionsMapAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.CollectionsSetAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.DefaultArrayAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.DefaultLambdaAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.DefaultListAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.DefaultLiteralAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.DefaultNullAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.DefaultProxyAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.DefaultQueueAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.DefaultSetAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.ObjectBuilderAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.ObjectFactoryAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.ProxyPlaceholderAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.SetupGenerator;
import net.amygdalum.testrecorder.deserializers.matcher.DefaultBigDecimalAdaptor;
import net.amygdalum.testrecorder.deserializers.matcher.DefaultBigIntegerAdaptor;
import net.amygdalum.testrecorder.deserializers.matcher.DefaultClassAdaptor;
import net.amygdalum.testrecorder.deserializers.matcher.DefaultEnumAdaptor;
import net.amygdalum.testrecorder.deserializers.matcher.DefaultMapAdaptor;
import net.amygdalum.testrecorder.deserializers.matcher.DefaultObjectAdaptor;
import net.amygdalum.testrecorder.deserializers.matcher.DefaultSequenceAdaptor;
import net.amygdalum.testrecorder.deserializers.matcher.LargePrimitiveArrayAdaptor;
import net.amygdalum.testrecorder.deserializers.matcher.MatcherGenerator;
import net.amygdalum.testrecorder.extensionpoint.ExtensionPoint;
import net.amygdalum.testrecorder.generator.DefaultTestGeneratorProfile;
import net.amygdalum.testrecorder.generator.TestGeneratorProfile;
import net.amygdalum.testrecorder.profile.AgentConfiguration;
import net.amygdalum.testrecorder.profile.FixedConfigurationLoader;
import net.amygdalum.testrecorder.profile.PerformanceProfile;
import net.amygdalum.testrecorder.profile.SerializationProfile;
import net.amygdalum.testrecorder.profile.SnapshotConsumer;
import net.amygdalum.testrecorder.serializers.ArraysListSerializer;
import net.amygdalum.testrecorder.serializers.BigDecimalSerializer;
import net.amygdalum.testrecorder.serializers.BigIntegerSerializer;
import net.amygdalum.testrecorder.serializers.ClassSerializer;
import net.amygdalum.testrecorder.serializers.CollectionsListSerializer;
import net.amygdalum.testrecorder.serializers.CollectionsMapSerializer;
import net.amygdalum.testrecorder.serializers.CollectionsSetSerializer;
import net.amygdalum.testrecorder.serializers.DefaultDequeSerializer;
import net.amygdalum.testrecorder.serializers.DefaultListSerializer;
import net.amygdalum.testrecorder.serializers.DefaultMapSerializer;
import net.amygdalum.testrecorder.serializers.DefaultQueueSerializer;
import net.amygdalum.testrecorder.serializers.DefaultSetSerializer;
import net.amygdalum.testrecorder.types.Serializer;

public class AgentConfigurator {
    private Map<Class<?>, FixedConfigurationLoader> configurationLoaders = new LinkedHashMap();

    public AgentConfigurator generateTests(Supplier<TestGeneratorProfile> profile) {
        return this.provideConfiguration(TestGeneratorProfile.class, args -> (TestGeneratorProfile)profile.get());
    }

    public AgentConfigurator optimizeTimings(Supplier<PerformanceProfile> profile) {
        return this.provideConfiguration(PerformanceProfile.class, args -> (PerformanceProfile)profile.get());
    }

    public AgentConfigurator record(Supplier<SerializationProfile> profile) {
        return this.provideConfiguration(SerializationProfile.class, args -> (SerializationProfile)profile.get());
    }

    public AgentConfigurator to(Function<AgentConfiguration, SnapshotConsumer> profile) {
        return this.provideConfiguration(SnapshotConsumer.class, args -> (SnapshotConsumer)profile.apply((AgentConfiguration)args[0]));
    }

    public <T> AgentConfigurator provideConfiguration(Class<T> clazz, Function<Object[], T> value) {
        assert (clazz.isAnnotationPresent(ExtensionPoint.class));
        this.configurationLoaders.computeIfAbsent(clazz, c -> new FixedConfigurationLoader()).provide(clazz, value);
        return this;
    }

    public AgentConfigurator defaultSerializers() {
        this.configurationLoaders.computeIfAbsent(Serializer.class, c -> new FixedConfigurationLoader()).provide(Serializer.class, args -> new ArraysListSerializer()).provide(Serializer.class, args -> new CollectionsListSerializer()).provide(Serializer.class, args -> new CollectionsSetSerializer()).provide(Serializer.class, args -> new CollectionsMapSerializer()).provide(Serializer.class, args -> new DefaultListSerializer()).provide(Serializer.class, args -> new DefaultQueueSerializer()).provide(Serializer.class, args -> new DefaultDequeSerializer()).provide(Serializer.class, args -> new DefaultSetSerializer()).provide(Serializer.class, args -> new DefaultMapSerializer()).provide(Serializer.class, args -> new ClassSerializer()).provide(Serializer.class, args -> new BigIntegerSerializer()).provide(Serializer.class, args -> new BigDecimalSerializer());
        return this;
    }

    public AgentConfigurator customSerializer(Supplier<Serializer<?>> serializer) {
        this.provideConfiguration(Serializer.class, args -> (Serializer)serializer.get());
        return this;
    }

    public AgentConfigurator defaultSetupGenerators() {
        this.configurationLoaders.computeIfAbsent(SetupGenerator.class, c -> new FixedConfigurationLoader()).provide(SetupGenerator.class, args -> new DefaultLiteralAdaptor()).provide(SetupGenerator.class, args -> new DefaultNullAdaptor()).provide(SetupGenerator.class, args -> new net.amygdalum.testrecorder.deserializers.builder.DefaultClassAdaptor()).provide(SetupGenerator.class, args -> new net.amygdalum.testrecorder.deserializers.builder.DefaultBigIntegerAdaptor()).provide(SetupGenerator.class, args -> new net.amygdalum.testrecorder.deserializers.builder.DefaultBigDecimalAdaptor()).provide(SetupGenerator.class, args -> new net.amygdalum.testrecorder.deserializers.builder.DefaultEnumAdaptor()).provide(SetupGenerator.class, args -> new DefaultLambdaAdaptor()).provide(SetupGenerator.class, args -> new DefaultProxyAdaptor()).provide(SetupGenerator.class, args -> new ProxyPlaceholderAdaptor()).provide(SetupGenerator.class, args -> new ObjectBuilderAdaptor()).provide(SetupGenerator.class, args -> new ObjectFactoryAdaptor()).provide(SetupGenerator.class, args -> new BeanObjectAdaptor()).provide(SetupGenerator.class, args -> new net.amygdalum.testrecorder.deserializers.builder.DefaultObjectAdaptor()).provide(SetupGenerator.class, args -> new DefaultArrayAdaptor()).provide(SetupGenerator.class, args -> new ArraysListAdaptor()).provide(SetupGenerator.class, args -> new CollectionsListAdaptor()).provide(SetupGenerator.class, args -> new DefaultListAdaptor()).provide(SetupGenerator.class, args -> new DefaultQueueAdaptor()).provide(SetupGenerator.class, args -> new CollectionsSetAdaptor()).provide(SetupGenerator.class, args -> new DefaultSetAdaptor()).provide(SetupGenerator.class, args -> new CollectionsMapAdaptor()).provide(SetupGenerator.class, args -> new net.amygdalum.testrecorder.deserializers.builder.DefaultMapAdaptor()).provide(SetupGenerator.class, args -> new net.amygdalum.testrecorder.deserializers.builder.LargePrimitiveArrayAdaptor());
        return this;
    }

    public AgentConfigurator customSetupGenerator(Supplier<SetupGenerator<?>> serializer) {
        this.provideConfiguration(SetupGenerator.class, args -> (SetupGenerator)serializer.get());
        return this;
    }

    public AgentConfigurator defaultMatcherGenerators() {
        this.configurationLoaders.computeIfAbsent(MatcherGenerator.class, c -> new FixedConfigurationLoader()).provide(MatcherGenerator.class, args -> new net.amygdalum.testrecorder.deserializers.matcher.DefaultLiteralAdaptor()).provide(MatcherGenerator.class, args -> new net.amygdalum.testrecorder.deserializers.matcher.DefaultNullAdaptor()).provide(MatcherGenerator.class, args -> new DefaultClassAdaptor()).provide(MatcherGenerator.class, args -> new DefaultBigIntegerAdaptor()).provide(MatcherGenerator.class, args -> new DefaultBigDecimalAdaptor()).provide(MatcherGenerator.class, args -> new DefaultEnumAdaptor()).provide(MatcherGenerator.class, args -> new net.amygdalum.testrecorder.deserializers.matcher.DefaultLambdaAdaptor()).provide(MatcherGenerator.class, args -> new net.amygdalum.testrecorder.deserializers.matcher.DefaultProxyAdaptor()).provide(MatcherGenerator.class, args -> new DefaultObjectAdaptor()).provide(MatcherGenerator.class, args -> new net.amygdalum.testrecorder.deserializers.matcher.DefaultArrayAdaptor()).provide(MatcherGenerator.class, args -> new DefaultSequenceAdaptor()).provide(MatcherGenerator.class, args -> new net.amygdalum.testrecorder.deserializers.matcher.DefaultSetAdaptor()).provide(MatcherGenerator.class, args -> new DefaultMapAdaptor()).provide(MatcherGenerator.class, args -> new LargePrimitiveArrayAdaptor());
        return this;
    }

    public AgentConfigurator customMatcherGenerator(Supplier<MatcherGenerator<?>> serializer) {
        this.provideConfiguration(MatcherGenerator.class, args -> (MatcherGenerator)serializer.get());
        return this;
    }

    public AgentConfiguration configure() {
        this.configurationLoaders.computeIfAbsent(SerializationProfile.class, c -> new FixedConfigurationLoader().provide(SerializationProfile.class, args -> new DefaultSerializationProfile()));
        this.configurationLoaders.computeIfAbsent(PerformanceProfile.class, c -> new FixedConfigurationLoader().provide(PerformanceProfile.class, args -> new DefaultPerformanceProfile()));
        this.configurationLoaders.computeIfAbsent(TestGeneratorProfile.class, c -> new FixedConfigurationLoader().provide(TestGeneratorProfile.class, args -> new DefaultTestGeneratorProfile()));
        this.configurationLoaders.computeIfAbsent(SnapshotConsumer.class, c -> new FixedConfigurationLoader().provide(SnapshotConsumer.class, args -> new DefaultSnapshotConsumer()));
        return new AgentConfiguration(this.configurationLoaders.values().stream().collect(Collectors.toList()));
    }
}

