/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.data;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import net.amygdalum.testrecorder.data.TestDataGenerator;
import net.amygdalum.testrecorder.data.TestValueGenerator;
import net.amygdalum.testrecorder.util.Reflections;
import net.amygdalum.testrecorder.util.Types;

public class GenericObjectGenerator<T>
implements TestValueGenerator<T> {
    private Class<T> clazz;

    public GenericObjectGenerator(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public T create(TestDataGenerator generator) {
        T instance = this.makeInstance(generator);
        for (Field field : Types.allFields(this.clazz)) {
            this.generateField(field, generator, instance);
        }
        return instance;
    }

    private T makeInstance(TestDataGenerator generator) {
        try {
            return this.clazz.newInstance();
        }
        catch (ReflectiveOperationException | RuntimeException exception) {
            for (Constructor<?> constructor : this.clazz.getDeclaredConstructors()) {
                try {
                    return (T)Reflections.accessing(constructor).call(c -> {
                        Object[] args = this.createArgs(generator, c.getParameterTypes());
                        return c.newInstance(args);
                    });
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                }
            }
            return null;
        }
    }

    private Object[] createArgs(TestDataGenerator generator, Class<?>[] parameterTypes) {
        Object[] args = new Object[parameterTypes.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = generator.create(parameterTypes[i]);
        }
        return args;
    }

    public void generateField(Field field, TestDataGenerator generator, T instance) {
        if (Types.isUnhandledSynthetic((Field)field)) {
            return;
        }
        try {
            Reflections.accessing((AccessibleObject)field).exec(f -> f.set(instance, generator.create(f.getType())));
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }
}

