/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.data;

import java.util.IdentityHashMap;
import java.util.Map;
import net.amygdalum.testrecorder.data.TestValueGenerator;
import net.amygdalum.testrecorder.runtime.DefaultValue;

public class TestDataGenerator {
    private Map<Class<?>, TestValueGenerator<?>> objectValues = new IdentityHashMap();

    public TestDataGenerator withValues(Class<?> clazz, TestValueGenerator<?> generator) {
        this.objectValues.put(clazz, generator);
        return this;
    }

    public <T> T create(Class<T> clazz) {
        TestValueGenerator gen = this.objectValues.computeIfAbsent(clazz, c -> new DefaultValueGenerator(c));
        return gen.create(this);
    }

    private static class DefaultValueGenerator<T>
    implements TestValueGenerator<T> {
        private Class<T> clazz;

        DefaultValueGenerator(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Override
        public T create(TestDataGenerator generator) {
            return (T)DefaultValue.of(this.clazz);
        }
    }
}

