/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.amygdalum.testrecorder.deserializers.Adaptor;
import net.amygdalum.testrecorder.deserializers.Deserializer;
import net.amygdalum.testrecorder.types.Computation;
import net.amygdalum.testrecorder.types.DeserializationException;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.types.TypeManager;

public class Adaptors {
    private Map<Class<? extends SerializedValue>, List<Adaptor<?>>> adaptors = new LinkedHashMap();

    public Adaptors load(List<? extends Adaptor> adaptors) {
        for (Adaptor adaptor : adaptors) {
            this.add(adaptor);
        }
        return this;
    }

    public Adaptors add(Adaptor<?> adaptor) {
        return this.add(adaptor.getAdaptedClass(), adaptor);
    }

    public Adaptors add(Class<? extends SerializedValue> clazz, Adaptor<?> adaptor) {
        List matching = this.adaptors.computeIfAbsent(clazz, key -> new LinkedList());
        if (matching.isEmpty() || adaptor.parent() == null) {
            matching.add(adaptor);
        } else if (matching.size() == 1) {
            Adaptor existing = (Adaptor)matching.get(0);
            if (existing.parent() == adaptor.getClass()) {
                matching.add(adaptor);
            } else {
                matching.add(0, adaptor);
            }
        } else {
            Adaptor prev;
            ListIterator<Adaptor<?>> iterator = matching.listIterator(matching.size());
            while (iterator.hasPrevious() && (prev = (Adaptor)iterator.previous()).getClass() != adaptor.parent()) {
                if (adaptor.getClass() != prev.parent()) continue;
                iterator.next();
                break;
            }
            if (iterator.hasPrevious()) {
                iterator.add(adaptor);
            } else {
                matching.add(0, adaptor);
            }
        }
        return this;
    }

    public <T extends SerializedValue> Computation tryDeserialize(T value, TypeManager types, Deserializer generator) {
        Class<?> clazz = value.getClass();
        List matching = this.adaptors.getOrDefault(clazz, Collections.emptyList());
        for (Adaptor match : matching) {
            if (!match.matches(value.getType())) continue;
            try {
                return match.tryDeserialize(value, generator);
            }
            catch (DeserializationException e) {
            }
        }
        return Computation.NULL;
    }
}

