/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.deserializers.DeserializerTypeManager;
import net.amygdalum.testrecorder.deserializers.HintManager;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.runtime.Wrapped;
import net.amygdalum.testrecorder.types.Computation;
import net.amygdalum.testrecorder.types.DeserializationException;
import net.amygdalum.testrecorder.types.DeserializerContext;
import net.amygdalum.testrecorder.types.LocalVariable;
import net.amygdalum.testrecorder.types.LocalVariableDefinition;
import net.amygdalum.testrecorder.types.LocalVariableNameGenerator;
import net.amygdalum.testrecorder.types.ReferenceTypeVisitor;
import net.amygdalum.testrecorder.types.RoleVisitor;
import net.amygdalum.testrecorder.types.SerializedImmutableType;
import net.amygdalum.testrecorder.types.SerializedReferenceType;
import net.amygdalum.testrecorder.types.SerializedRole;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.types.TypeManager;
import net.amygdalum.testrecorder.util.Types;

public class DefaultDeserializerContext
implements DeserializerContext {
    private static final SerializedReferenceType GLOBAL_REFERRER = new GlobalRoot();
    private Map<SerializedValue, Set<SerializedReferenceType>> backReferences;
    private Map<SerializedValue, Set<SerializedValue>> closures;
    private HintManager hints;
    private LocalVariableNameGenerator locals;
    private TypeManager types;
    private Map<SerializedValue, LocalVariable> defined;
    private Set<SerializedValue> computed;
    private Deque<SerializedRole> stack;

    public DefaultDeserializerContext(TypeManager types, LocalVariableNameGenerator locals) {
        this(new IdentityHashMap<SerializedValue, Set<SerializedReferenceType>>(), new IdentityHashMap<SerializedValue, Set<SerializedValue>>(), new HintManager(), types, locals);
    }

    public DefaultDeserializerContext() {
        this.backReferences = new IdentityHashMap<SerializedValue, Set<SerializedReferenceType>>();
        this.closures = new IdentityHashMap<SerializedValue, Set<SerializedValue>>();
        this.hints = new HintManager();
        this.types = new DeserializerTypeManager();
        this.locals = new LocalVariableNameGenerator();
        this.defined = new IdentityHashMap<SerializedValue, LocalVariable>();
        this.computed = new HashSet<SerializedValue>();
        this.stack = new LinkedList<SerializedRole>();
    }

    private DefaultDeserializerContext(Map<SerializedValue, Set<SerializedReferenceType>> backReferences, Map<SerializedValue, Set<SerializedValue>> closures, HintManager hints, TypeManager types, LocalVariableNameGenerator locals) {
        this.backReferences = backReferences;
        this.closures = closures;
        this.hints = hints;
        this.types = types;
        this.locals = locals;
        this.defined = new IdentityHashMap<SerializedValue, LocalVariable>();
        this.computed = new HashSet<SerializedValue>();
        this.stack = new LinkedList<SerializedRole>();
    }

    public static DefaultDeserializerContext empty() {
        return new DefaultDeserializerContext();
    }

    @Override
    public void clear() {
        this.backReferences.clear();
        this.closures.clear();
        this.hints = new HintManager();
        this.types = new DeserializerTypeManager();
        this.locals = new LocalVariableNameGenerator();
        this.defined.clear();
        this.computed.clear();
        this.stack.clear();
    }

    @Override
    public LocalVariableNameGenerator getLocals() {
        return this.locals;
    }

    @Override
    public TypeManager getTypes() {
        return this.types;
    }

    @Override
    public String temporaryLocal() {
        return this.locals.fetchName("temp");
    }

    @Override
    public String newLocal(String name) {
        return this.locals.fetchName(name);
    }

    @Override
    public LocalVariable localVariable(SerializedValue value, Type type) {
        String name = this.locals.fetchName(type);
        LocalVariable definition = new LocalVariable(name, type);
        this.defined.put(value, definition);
        return definition;
    }

    @Override
    public void finishVariable(SerializedValue value) {
        this.defined.computeIfPresent(value, (val, def) -> def.finish());
    }

    @Override
    public void resetVariable(SerializedValue value) {
        LocalVariable variable = this.defined.remove(value);
        this.locals.freeName(variable.getName());
    }

    @Override
    public boolean defines(SerializedValue value) {
        return this.defined.containsKey(value);
    }

    @Override
    public LocalVariable getDefinition(SerializedValue value) {
        return this.defined.get(value);
    }

    @Override
    public <T> DefaultDeserializerContext newIsolatedContext(TypeManager types, LocalVariableNameGenerator locals) {
        return new DefaultDeserializerContext(this.backReferences, this.closures, this.hints, types, locals);
    }

    @Override
    public void addHint(AnnotatedElement role, Object hint) {
        this.hints.addHint(role, hint);
    }

    @Override
    public <T> Optional<T> getHint(SerializedRole role, Class<T> clazz) {
        return this.fetchHints(role, clazz).findFirst();
    }

    @Override
    public <T> Stream<T> getHints(SerializedRole role, Class<T> clazz) {
        return this.fetchHints(role, clazz);
    }

    private <T> Stream<T> fetchHints(SerializedRole role, Class<T> clazz) {
        Stream<SerializedRole> roles = this.findRoles(role);
        return roles.flatMap(r -> this.hints.fetch(clazz, (SerializedRole)r));
    }

    private Stream<SerializedRole> findRoles(SerializedRole role) {
        Iterator<SerializedRole> iterator = this.stack.iterator();
        if (!iterator.hasNext() || iterator.next() != role) {
            return Stream.of(role);
        }
        if (iterator.hasNext()) {
            SerializedRole parent = iterator.next();
            if (parent instanceof SerializedValue) {
                return Stream.of(role);
            }
            return Stream.of(parent, role);
        }
        return Stream.of(role);
    }

    @Override
    public <T> Optional<T> getHint(AnnotatedElement element, Class<T> clazz) {
        return this.fetchHints(element, clazz).findFirst();
    }

    @Override
    public <T> Stream<T> getHints(AnnotatedElement element, Class<T> clazz) {
        return this.fetchHints(element, clazz);
    }

    private <T> Stream<T> fetchHints(AnnotatedElement element, Class<T> clazz) {
        return this.hints.fetch(clazz, element);
    }

    @Override
    public int refCount(SerializedValue value) {
        int size = 0;
        Set<SerializedReferenceType> references = this.backReferences.get(value);
        if (references != null) {
            size += references.size();
        }
        return size;
    }

    @Override
    public void ref(SerializedReferenceType value, SerializedValue referencedValue) {
        this.backReferences.computeIfAbsent(referencedValue, key -> new HashSet()).add(value);
    }

    @Override
    public void staticRef(SerializedValue referencedValue) {
        this.backReferences.computeIfAbsent(referencedValue, key -> new HashSet()).add(GLOBAL_REFERRER);
    }

    @Override
    public Set<SerializedValue> closureOf(SerializedValue value) {
        Set<SerializedValue> closure = this.closures.get(value);
        if (closure != null) {
            return closure;
        }
        if (value instanceof SerializedImmutableType) {
            return Collections.singleton(value);
        }
        if (value instanceof SerializedReferenceType) {
            this.closures.put(value, Collections.singleton(value));
            closure = new HashSet<SerializedValue>();
            closure.add(value);
            value.referencedValues().stream().flatMap(val -> this.closureOf((SerializedValue)val).stream()).forEach(closure::add);
            this.closures.put(value, closure);
            return closure;
        }
        return Collections.singleton(value);
    }

    @Override
    public String adapt(String expression, Type resultType, Type type) {
        if (this.needsUnwrapping(resultType, (Type)type)) {
            if (this.types.isHidden(resultType) || Types.baseType((Type)resultType) == Object.class) {
                type = Object.class;
                expression = Templates.callMethod(expression, "value", new String[0]);
            } else {
                type = Types.baseType((Type)resultType);
                expression = Templates.callMethod(expression, "value", this.types.getRawClass((Type)type));
            }
        }
        if (!(Types.assignableTypes((Type)resultType, (Type)type) && !this.types.isHidden((Type)type) || Types.boxingEquivalentTypes((Type)resultType, (Type)type) || Types.baseType((Type)resultType) == Wrapped.class)) {
            if (Types.isGeneric((Type)resultType) && Types.isGeneric((Type)type)) {
                expression = Templates.cast(this.types.getRawTypeName(resultType), expression);
            }
            expression = Templates.cast(this.types.getVariableTypeName(resultType), expression);
        }
        return expression;
    }

    private boolean needsUnwrapping(Type resultType, Type type) {
        return Types.baseType((Type)resultType) != Wrapped.class && type == Wrapped.class || Types.baseType((Type)resultType) != Wrapped.class && this.types.isHidden(type);
    }

    @Override
    public boolean needsAdaptation(Type resultType, Type type) {
        if (resultType == null || type == null) {
            return false;
        }
        if (Types.baseType((Type)resultType) != Wrapped.class && type == Wrapped.class) {
            return true;
        }
        if (Types.baseType((Type)resultType) != Wrapped.class && this.types.isHidden(type)) {
            return true;
        }
        return (!Types.assignableTypes((Type)resultType, (Type)type) || this.types.isHidden(type)) && !Types.boxingEquivalentTypes((Type)resultType, (Type)type) && Types.baseType((Type)resultType) != Wrapped.class;
    }

    @Override
    public Computation forVariable(SerializedValue value, Type type, LocalVariableDefinition computation) {
        LocalVariable local = this.localVariable(value, type);
        try {
            Computation definition = computation.define(local);
            this.finishVariable(value);
            return definition;
        }
        catch (DeserializationException e) {
            this.resetVariable(value);
            throw e;
        }
    }

    @Override
    public boolean isComputed(SerializedValue value) {
        boolean changed = this.computed.add(value);
        return !changed;
    }

    @Override
    public Optional<SerializedValue> resolve(int id) {
        return this.defined.keySet().stream().filter(value -> value instanceof SerializedReferenceType && ((SerializedReferenceType)value).getId() == id).findFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends SerializedRole, S> S withRole(T role, Function<T, S> continuation) {
        try {
            this.stack.push(role);
            S s = continuation.apply(role);
            return s;
        }
        finally {
            this.stack.pop();
        }
    }

    private static class GlobalRoot
    implements SerializedReferenceType {
        GlobalRoot() {
        }

        @Override
        public <T> T accept(RoleVisitor<T> visitor) {
            return null;
        }

        @Override
        public <T> T accept(ReferenceTypeVisitor<T> visitor) {
            return null;
        }

        @Override
        public void useAs(Type resultType) {
        }

        @Override
        public Type[] getUsedTypes() {
            return new Type[]{Class.class};
        }

        @Override
        public Class<?> getType() {
            return Class.class;
        }

        @Override
        public List<SerializedValue> referencedValues() {
            return Collections.emptyList();
        }

        @Override
        public void setId(int id) {
        }

        @Override
        public int getId() {
            return 0;
        }
    }
}

