/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.runtime.Wrapped;
import net.amygdalum.testrecorder.types.TypeManager;
import net.amygdalum.testrecorder.util.Types;

public class DeserializerTypeManager
implements TypeManager {
    private static final String DEFAULT_PKG = "java.lang";
    private static final String WILDCARD = "?";
    private String pkg;
    private Map<String, String> imports;
    private Set<String> staticImports;
    private Set<Type> noImports;

    public DeserializerTypeManager() {
        this("");
    }

    public DeserializerTypeManager(String pkg) {
        this.pkg = pkg;
        this.imports = new LinkedHashMap<String, String>();
        this.staticImports = new LinkedHashSet<String>();
        this.noImports = new LinkedHashSet<Type>();
    }

    @Override
    public String getPackage() {
        return this.pkg;
    }

    @Override
    public List<String> getImports() {
        return Stream.concat(this.imports.values().stream(), this.staticImports.stream()).collect(Collectors.toList());
    }

    @Override
    public void staticImport(Class<?> type, String method) {
        this.staticImports.add("static " + type.getName() + "." + method);
    }

    @Override
    public void registerTypes(Type ... types) {
        for (Type type : types) {
            this.registerType(type);
        }
    }

    @Override
    public void registerType(Type type) {
        if (type instanceof Class) {
            this.registerImport((Class)type);
        } else if (type instanceof GenericArrayType) {
            this.registerType(((GenericArrayType)type).getGenericComponentType());
        } else if (type instanceof ParameterizedType) {
            this.registerType(((ParameterizedType)type).getRawType());
            this.registerTypes(((ParameterizedType)type).getActualTypeArguments());
        }
    }

    @Override
    public void registerImport(Class<?> clazz) {
        if (this.cannotBeNotImported(clazz)) {
            return;
        }
        if (this.isHidden(clazz)) {
            this.registerImport(Wrapped.class);
            this.staticImport(Wrapped.class, "clazz");
            this.noImports.add(clazz);
        } else if (this.isColliding(clazz)) {
            this.noImports.add(clazz);
        } else {
            if (clazz.isPrimitive()) {
                return;
            }
            if (clazz.isArray()) {
                this.registerImport(clazz.getComponentType());
            } else {
                this.imports.put(clazz.getSimpleName(), clazz.getCanonicalName());
            }
        }
    }

    @Override
    public String getVariableTypeName(Type type) {
        if (type instanceof Class) {
            Class<?> clazz = (Class<?>)type;
            String array = "";
            while (clazz.isArray()) {
                array = array + "[]";
                clazz = clazz.getComponentType();
            }
            String base = this.isNotImported(clazz) ? clazz.getCanonicalName() : clazz.getSimpleName();
            return base + array;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return this.getVariableTypeName(genericArrayType.getGenericComponentType()) + "[]";
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return this.getRawTypeName(parameterizedType.getRawType()) + Stream.of(parameterizedType.getActualTypeArguments()).map(argtype -> argtype instanceof TypeVariable ? Types.wildcard() : argtype).map(argtype -> this.getVariableTypeName((Type)argtype)).collect(Collectors.joining(", ", "<", ">"));
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            if (typeVariable.getBounds().length == 1) {
                return this.getVariableTypeName(typeVariable.getBounds()[0]);
            }
            return this.getVariableTypeName((Type)((Object)Object.class));
        }
        if (type instanceof WildcardType) {
            return WILDCARD;
        }
        return this.getVariableTypeName((Type)((Object)Object.class));
    }

    @Override
    public String getConstructorTypeName(Type type) {
        if (type instanceof Class) {
            String base;
            Class<?> clazz = (Class<?>)type;
            String array = "";
            while (clazz.isArray()) {
                array = array + "[]";
                clazz = clazz.getComponentType();
            }
            String string = base = this.isNotImported(clazz) ? clazz.getCanonicalName() : clazz.getSimpleName();
            String generics = array.length() == 0 ? (clazz.getTypeParameters().length > 0 ? "<>" : "") : "";
            return base + generics + array;
        }
        if (type instanceof GenericArrayType) {
            return this.getConstructorTypeName(((GenericArrayType)type).getGenericComponentType()) + "[]";
        }
        if (type instanceof ParameterizedType) {
            return this.getRawTypeName(((ParameterizedType)type).getRawType()) + Stream.of(((ParameterizedType)type).getActualTypeArguments()).filter(Types::isBound).map(argtype -> this.getVariableTypeName((Type)argtype)).collect(Collectors.joining(", ", "<", ">"));
        }
        return this.getConstructorTypeName((Type)((Object)Object.class));
    }

    @Override
    public String getRawTypeName(Type type) {
        if (type instanceof Class) {
            Class<?> clazz = (Class<?>)type;
            String array = "";
            while (clazz.isArray()) {
                array = array + "[]";
                clazz = clazz.getComponentType();
            }
            String name = this.isNotImported(clazz) ? clazz.getCanonicalName() : clazz.getSimpleName();
            return name + array;
        }
        if (type instanceof GenericArrayType) {
            return this.getRawTypeName(((GenericArrayType)type).getGenericComponentType()) + "[]";
        }
        if (type instanceof ParameterizedType) {
            return this.getRawTypeName(((ParameterizedType)type).getRawType());
        }
        return this.getRawTypeName((Type)((Object)Object.class));
    }

    @Override
    public String getRawClass(String type) {
        try {
            return this.getRawClass(Class.forName(type));
        }
        catch (ClassNotFoundException e) {
            return this.getRawClass((Type)((Object)Object.class));
        }
    }

    @Override
    public String getRawClass(Type type) {
        if (this.isHidden(type)) {
            return this.getWrappedName(type);
        }
        return this.getRawTypeName(type) + ".class";
    }

    @Override
    public boolean isHidden(Constructor<?> constructor) {
        return Types.isHidden(constructor, (String)this.pkg);
    }

    @Override
    public boolean isHidden(Method method) {
        return Types.isHidden((Method)method, (String)this.pkg);
    }

    @Override
    public boolean isHidden(Type type) {
        return Types.isHidden((Type)type, (String)this.pkg);
    }

    @Override
    public boolean isGenericVariable(Type type) {
        return Types.isGenericVariable((Type)type);
    }

    @Override
    public boolean isErasureHidden(Type type) {
        return Types.isErasureHidden((Type)type, (String)this.pkg);
    }

    @Override
    public boolean isColliding(Class<?> clazz) {
        return this.imports.containsKey(clazz.getSimpleName()) && !this.imports.get(clazz.getSimpleName()).equals(clazz.getCanonicalName());
    }

    private boolean cannotBeNotImported(Class<?> clazz) {
        return this.noImports.contains(clazz);
    }

    @Override
    public boolean isNotImported(Class<?> clazz) {
        if (clazz.getPackage() != null && clazz.getPackage().getName().equals(DEFAULT_PKG)) {
            return this.noImports.contains(clazz);
        }
        return !this.imports.containsKey(clazz.getSimpleName()) || !this.imports.get(clazz.getSimpleName()).equals(clazz.getCanonicalName());
    }

    @Override
    public Type wrapHidden(Type type) {
        if (this.isHidden(type)) {
            return Wrapped.class;
        }
        return type;
    }

    @Override
    public String getWrappedName(Type type) {
        return "clazz(\"" + Types.baseType((Type)type).getName() + "\")";
    }

    @Override
    public Type bestType(Type preferred, Class<?> bound) {
        if (this.isGenericVariable(preferred)) {
            TypeVariable variable = (TypeVariable)preferred;
            Class bestClass = bound;
            Type bestType = bound;
            for (Type boundingType : variable.getBounds()) {
                Class boundingClass = Types.baseType((Type)(boundingType = this.bestType(boundingType, bound)));
                if (!bestClass.isAssignableFrom(boundingClass)) continue;
                bestClass = boundingClass;
                bestType = boundingType;
            }
            return bestType;
        }
        if (this.isHidden(preferred)) {
            Class clazz;
            for (clazz = Types.baseType((Type)preferred); clazz != Object.class && this.isHidden(clazz); clazz = clazz.getSuperclass()) {
            }
            if (clazz == Object.class || clazz == null) {
                return bound;
            }
            return clazz;
        }
        if (this.isErasureHidden(preferred)) {
            return Types.baseType((Type)preferred);
        }
        return preferred;
    }

    @Override
    public Type bestType(Type preferred, Type secondary, Class<?> bound) {
        if (!this.isHidden(preferred) && !this.isErasureHidden(preferred) && bound.isAssignableFrom(Types.baseType((Type)preferred))) {
            return preferred;
        }
        if (bound.isAssignableFrom(Types.baseType((Type)secondary))) {
            return secondary;
        }
        return bound;
    }

    @Override
    public Optional<Type> mostSpecialOf(Type ... types) {
        Type[] visibleTypes = (Type[])Arrays.stream(types).filter(type -> !this.isHidden((Type)type)).toArray(Type[]::new);
        return Types.mostSpecialOf((Type[])visibleTypes);
    }
}

