/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.amygdalum.testrecorder.types.FieldSignature;
import net.amygdalum.testrecorder.types.SerializedField;

public final class FieldNamingStrategy {
    private static final List<Function<SerializedField, String>> NAMING_STRATEGIES = Arrays.asList(FieldNamingStrategy.qualifySimple(), FieldNamingStrategy.qualifyCanonical());

    private FieldNamingStrategy() {
    }

    public static List<SerializedField> ensureUniqueNames(List<SerializedField> fields) {
        if (FieldNamingStrategy.containsUniqueNames(fields)) {
            return fields;
        }
        List<SerializedField> collect = fields.stream().collect(Collectors.groupingBy(SerializedField::getName, Collectors.toList())).values().stream().map(equalfields -> FieldNamingStrategy.applyStrategys(equalfields)).flatMap(Collection::stream).collect(Collectors.toList());
        return collect;
    }

    private static List<SerializedField> applyStrategys(List<SerializedField> equalfields) {
        for (Function<SerializedField, String> naming : NAMING_STRATEGIES) {
            List<SerializedField> qualified = equalfields.stream().map(field -> new SerializedField(new FieldSignature(field.getDeclaringClass(), field.getType(), (String)naming.apply((SerializedField)field)), field.getValue())).collect(Collectors.toList());
            if (!FieldNamingStrategy.containsUniqueNames(qualified)) continue;
            return qualified;
        }
        return equalfields;
    }

    private static boolean containsUniqueNames(List<SerializedField> fields) {
        return fields.stream().map(SerializedField::getName).distinct().count() == (long)fields.size();
    }

    private static Function<SerializedField, String> qualifySimple() {
        return field -> field.getDeclaringClass().getSimpleName().replace('.', '$') + "$" + field.getName();
    }

    private static Function<SerializedField, String> qualifyCanonical() {
        return field -> field.getDeclaringClass().getCanonicalName().replace('.', '$') + "$" + field.getName();
    }
}

