/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers;

import java.util.function.Function;
import net.amygdalum.testrecorder.types.RoleVisitor;
import net.amygdalum.testrecorder.types.SerializedArgument;
import net.amygdalum.testrecorder.types.SerializedField;
import net.amygdalum.testrecorder.types.SerializedImmutableType;
import net.amygdalum.testrecorder.types.SerializedReferenceType;
import net.amygdalum.testrecorder.types.SerializedResult;
import net.amygdalum.testrecorder.types.SerializedValueType;

public class MappedRoleVisitor<T, S>
implements RoleVisitor<T> {
    private RoleVisitor<S> visitor;
    private Function<S, T> mapping;

    public MappedRoleVisitor(RoleVisitor<S> visitor, Function<S, T> mapping) {
        this.visitor = visitor;
        this.mapping = mapping;
    }

    @Override
    public T visitField(SerializedField field) {
        return this.mapping.apply(field.accept(this.visitor));
    }

    @Override
    public T visitArgument(SerializedArgument argument) {
        return this.mapping.apply(argument.accept(this.visitor));
    }

    @Override
    public T visitResult(SerializedResult result) {
        return this.mapping.apply(result.accept(this.visitor));
    }

    @Override
    public T visitReferenceType(SerializedReferenceType value) {
        return this.mapping.apply(value.accept(this.visitor));
    }

    @Override
    public T visitImmutableType(SerializedImmutableType value) {
        return this.mapping.apply(value.accept(this.visitor));
    }

    @Override
    public T visitValueType(SerializedValueType value) {
        return this.mapping.apply(value.accept(this.visitor));
    }
}

