/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers;

import net.amygdalum.testrecorder.deserializers.DefaultDeserializerContext;
import net.amygdalum.testrecorder.deserializers.TreeAnalysisListener;
import net.amygdalum.testrecorder.types.SerializedAggregateType;
import net.amygdalum.testrecorder.types.SerializedArgument;
import net.amygdalum.testrecorder.types.SerializedField;
import net.amygdalum.testrecorder.types.SerializedReferenceType;
import net.amygdalum.testrecorder.types.SerializedResult;
import net.amygdalum.testrecorder.types.SerializedStructuralType;
import net.amygdalum.testrecorder.types.SerializedValue;

public class ReferenceAnalyzer
implements TreeAnalysisListener {
    private DefaultDeserializerContext context;

    public ReferenceAnalyzer(DefaultDeserializerContext context) {
        this.context = context;
    }

    @Override
    public void notifyThis(SerializedValue self) {
        this.staticReference(self);
    }

    @Override
    public void notifyArgument(SerializedArgument argument) {
        this.staticReference(argument.getValue());
    }

    @Override
    public void notifyResult(SerializedResult result) {
        this.staticReference(result.getValue());
    }

    @Override
    public void notifyException(SerializedValue exception) {
        this.staticReference(exception);
    }

    @Override
    public void notifyInput(SerializedValue in) {
        this.staticReference(in);
    }

    @Override
    public void notifyOutput(SerializedValue out) {
        this.staticReference(out);
    }

    @Override
    public void notifyGlobal(SerializedField global) {
        this.staticReference(global.getValue());
    }

    @Override
    public void notifyField(SerializedStructuralType self, SerializedField field) {
        this.reference(self, field.getValue());
    }

    @Override
    public void notifyAggregate(SerializedAggregateType self, SerializedValue value) {
        this.reference(self, value);
    }

    @Override
    public void notifyReference(SerializedReferenceType self, SerializedValue value) {
        this.reference(self, value);
    }

    private void staticReference(SerializedValue value) {
        this.context.staticRef(value);
    }

    public void reference(SerializedReferenceType object, SerializedValue value) {
        this.context.ref(object, value);
    }
}

