/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.amygdalum.testrecorder.deserializers.TreeAnalysisListener;
import net.amygdalum.testrecorder.types.ContextSnapshot;
import net.amygdalum.testrecorder.types.ReferenceTypeVisitor;
import net.amygdalum.testrecorder.types.SerializedAggregateType;
import net.amygdalum.testrecorder.types.SerializedArgument;
import net.amygdalum.testrecorder.types.SerializedField;
import net.amygdalum.testrecorder.types.SerializedImmutableType;
import net.amygdalum.testrecorder.types.SerializedInput;
import net.amygdalum.testrecorder.types.SerializedOutput;
import net.amygdalum.testrecorder.types.SerializedReferenceType;
import net.amygdalum.testrecorder.types.SerializedResult;
import net.amygdalum.testrecorder.types.SerializedStructuralType;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.util.IdentityWorkSet;

public class TreeAnalyzer
implements ReferenceTypeVisitor<Void> {
    private IdentityWorkSet<SerializedReferenceType> todo = new IdentityWorkSet();
    private Set<Integer> inputs = new HashSet<Integer>();
    private Set<Integer> outputs = new HashSet<Integer>();
    private List<TreeAnalysisListener> listeners = new ArrayList<TreeAnalysisListener>();

    public TreeAnalyzer addListener(TreeAnalysisListener listener) {
        this.listeners.add(listener);
        return this;
    }

    private void addThis(SerializedValue value) {
        this.listeners.forEach(listener -> listener.notifyThis(value));
        this.analyzeValue(value);
    }

    private void addException(SerializedValue value) {
        this.listeners.forEach(listener -> listener.notifyThis(value));
        this.analyzeValue(value);
    }

    private void addArgument(SerializedArgument argument) {
        this.listeners.forEach(listener -> listener.notifyArgument(argument));
        this.analyzeValue(argument.getValue());
    }

    private void addResult(SerializedResult result) {
        this.listeners.forEach(listener -> listener.notifyResult(result));
        this.analyzeValue(result.getValue());
    }

    private void addGlobal(SerializedField field) {
        this.listeners.forEach(listener -> listener.notifyGlobal(field));
        this.analyzeValue(field.getValue());
    }

    private void addInput(SerializedInput in) {
        this.inputs.add(in.getId());
        in.getAllValues().stream().filter(Objects::nonNull).forEach(this::analyzeValue);
    }

    private void addOutput(SerializedOutput out) {
        this.outputs.add(out.getId());
        out.getAllValues().stream().filter(Objects::nonNull).forEach(this::analyzeValue);
    }

    private void analyzeValue(SerializedValue value) {
        if (value instanceof SerializedReferenceType) {
            SerializedReferenceType object = (SerializedReferenceType)value;
            if (this.inputs.contains(object.getId())) {
                for (TreeAnalysisListener listener : this.listeners) {
                    listener.notifyInput(value);
                }
            }
            if (this.outputs.contains(object.getId())) {
                for (TreeAnalysisListener listener : this.listeners) {
                    listener.notifyOutput(value);
                }
            }
            this.todo.add((Object)object);
        }
    }

    private void analyze() {
        while (this.todo.hasMoreElements()) {
            SerializedReferenceType object = (SerializedReferenceType)this.todo.remove();
            object.accept(this);
        }
    }

    @Override
    public Void visitAggregateType(SerializedAggregateType value) {
        value.elements().stream().peek(ref -> this.listeners.forEach(listener -> listener.notifyAggregate(value, (SerializedValue)ref))).forEach(this::analyzeValue);
        return null;
    }

    @Override
    public Void visitStructuralType(SerializedStructuralType value) {
        value.fields().stream().peek(ref -> this.listeners.forEach(listener -> listener.notifyField(value, (SerializedField)ref))).map(ref -> ref.getValue()).forEach(this::analyzeValue);
        return null;
    }

    @Override
    public Void visitImmutableType(SerializedImmutableType value) {
        value.referencedValues().stream().peek(ref -> this.listeners.forEach(listener -> listener.notifyReference(value, (SerializedValue)ref))).forEach(this::analyzeValue);
        return null;
    }

    public void analyze(ContextSnapshot snapshot) {
        snapshot.onSetupThis().ifPresent(self -> this.addThis((SerializedValue)self));
        snapshot.onExpectThis().ifPresent(self -> this.addThis((SerializedValue)self));
        snapshot.streamSetupArgs().forEach(arg -> this.addArgument((SerializedArgument)arg));
        snapshot.streamExpectArgs().forEach(arg -> this.addArgument((SerializedArgument)arg));
        snapshot.onExpectResult().ifPresent(result -> this.addResult((SerializedResult)result));
        snapshot.onExpectException().ifPresent(exception -> this.addException((SerializedValue)exception));
        snapshot.streamSetupGlobals().filter(Objects::nonNull).forEach(global -> this.addGlobal((SerializedField)global));
        snapshot.streamExpectGlobals().filter(Objects::nonNull).forEach(global -> this.addGlobal((SerializedField)global));
        snapshot.streamInput().forEach(input -> this.addInput((SerializedInput)input));
        snapshot.streamOutput().forEach(output -> this.addOutput((SerializedOutput)output));
        this.analyze();
    }
}

