/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.builder;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.amygdalum.testrecorder.deserializers.Deserializer;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.builder.DefaultArrayAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.DefaultListAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.SetupGenerator;
import net.amygdalum.testrecorder.types.Computation;
import net.amygdalum.testrecorder.types.DeserializationException;
import net.amygdalum.testrecorder.types.DeserializerContext;
import net.amygdalum.testrecorder.types.LocalVariable;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.types.TypeManager;
import net.amygdalum.testrecorder.util.SerializableParameterizedType;
import net.amygdalum.testrecorder.util.TypeFilters;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedArray;
import net.amygdalum.testrecorder.values.SerializedList;

public class ArraysListAdaptor
implements SetupGenerator<SerializedList> {
    private DefaultArrayAdaptor adaptor = new DefaultArrayAdaptor();

    @Override
    public Class<SerializedList> getAdaptedClass() {
        return SerializedList.class;
    }

    @Override
    public Class<? extends SetupGenerator<SerializedList>> parent() {
        return DefaultListAdaptor.class;
    }

    @Override
    public boolean matches(Type type) {
        return Types.innerClasses(Arrays.class).stream().filter(TypeFilters.in((String[])new String[]{"ArrayList"})).filter(element -> List.class.isAssignableFrom((Class<?>)element)).anyMatch(element -> Types.equalBaseTypes((Type)element, (Type)type));
    }

    @Override
    public Computation tryDeserialize(SerializedList value, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        TypeManager types = context.getTypes();
        Type componentType = value.getComponentType();
        types.staticImport(Arrays.class, "asList");
        types.registerType(componentType);
        Type type = Types.array((Type)componentType);
        SerializedArray baseValue = new SerializedArray(Types.baseType((Type)type));
        baseValue.useAs(type);
        for (SerializedValue element : value) {
            baseValue.add(element);
        }
        SerializableParameterizedType resultType = types.isHidden(componentType) ? Types.parameterized(List.class, null, (Type[])new Type[]{Types.wildcard()}) : Types.parameterized(List.class, null, (Type[])new Type[]{componentType});
        return context.forVariable(value, (Type)resultType, arg_0 -> this.lambda$tryDeserialize$2(baseValue, generator, types, (Type)resultType, arg_0));
    }

    private /* synthetic */ Computation lambda$tryDeserialize$2(SerializedArray baseValue, Deserializer generator, TypeManager types, Type resultType, LocalVariable local) throws DeserializationException {
        Computation computation = this.adaptor.tryDeserialize(baseValue, generator);
        LinkedList<String> statements = new LinkedList<String>(computation.getStatements());
        String resultArray = computation.getValue();
        String asListStatement = Templates.assignLocalVariableStatement(types.getVariableTypeName(resultType), local.getName(), Templates.callLocalMethod("asList", resultArray));
        statements.add(asListStatement);
        return Computation.variable(local.getName(), local.getType(), statements);
    }
}

