/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.builder;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.amygdalum.testrecorder.deserializers.Deserializer;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.hints.Builder;
import net.amygdalum.testrecorder.types.Computation;
import net.amygdalum.testrecorder.types.DeserializerContext;
import net.amygdalum.testrecorder.types.LocalVariable;
import net.amygdalum.testrecorder.types.SerializedField;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.types.TypeManager;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedObject;

public class BuilderConstruction {
    private static final String WITH = "with";
    private static final String BUILD = "build";
    private DeserializerContext context;
    private SerializedObject serialized;
    private LocalVariable var;

    public BuilderConstruction(DeserializerContext context, LocalVariable var, SerializedObject value) {
        this.context = context;
        this.var = var;
        this.serialized = value;
    }

    public Computation build(TypeManager types, Deserializer generator) throws ReflectiveOperationException {
        Class builderClass = this.context.getHint(this.serialized, Builder.class).orElseThrow(() -> new InstantiationException()).builder();
        BuilderModel model = this.assertBuilderConventions(builderClass);
        return model.build(types, generator);
    }

    private BuilderModel assertBuilderConventions(Class<?> builderClass) throws ReflectiveOperationException {
        builderClass.getConstructor(new Class[0]);
        ArrayList<WithSetter> withSetters = new ArrayList<WithSetter>();
        for (SerializedField field : this.serialized.getFields()) {
            String withSetter = this.withSetterNameFor(field.getName());
            Method method = Types.getDeclaredMethod(builderClass, (String)withSetter, (Class[])new Class[]{Types.baseType((Type)field.getType())});
            if (method.getReturnType() != builderClass) {
                throw new NoSuchMethodException();
            }
            withSetters.add(new WithSetter(withSetter, field.getValue()));
        }
        Method builderMethod = builderClass.getMethod(BUILD, new Class[0]);
        if (builderMethod.getReturnType() != this.serialized.getType()) {
            throw new NoSuchMethodException();
        }
        return new BuilderModel(this.var, builderClass, withSetters);
    }

    private String withSetterNameFor(String name) {
        return WITH + Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    private static class WithSetter {
        public String method;
        public SerializedValue value;

        WithSetter(String method, SerializedValue value) {
            this.method = method;
            this.value = value;
        }
    }

    private static class BuilderModel {
        private String name;
        private Type type;
        private Type builderClass;
        private List<WithSetter> withSetters;

        BuilderModel(LocalVariable var, Type builderClass, List<WithSetter> withSetters) {
            this.name = var.getName();
            this.type = var.getType();
            this.builderClass = builderClass;
            this.withSetters = withSetters;
        }

        public Computation build(TypeManager types, Deserializer generator) {
            types.registerTypes(this.builderClass);
            ArrayList<String> statements = new ArrayList<String>();
            String aggregate = Templates.newObject(types.getVariableTypeName(this.builderClass), new String[0]);
            for (WithSetter withSetter : this.withSetters) {
                Computation fieldComputation = withSetter.value.accept(generator);
                statements.addAll(fieldComputation.getStatements());
                aggregate = Templates.callMethod(aggregate, withSetter.method, fieldComputation.getValue());
            }
            aggregate = Templates.callMethod(aggregate, BuilderConstruction.BUILD, new String[0]);
            statements.add(Templates.assignLocalVariableStatement(types.getVariableTypeName(this.type), this.name, aggregate));
            return Computation.variable(this.name, this.type, statements);
        }
    }
}

