/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.builder;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.amygdalum.testrecorder.deserializers.Deserializer;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.builder.DefaultListAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.SetupGenerator;
import net.amygdalum.testrecorder.types.Computation;
import net.amygdalum.testrecorder.types.DeserializationException;
import net.amygdalum.testrecorder.types.DeserializerContext;
import net.amygdalum.testrecorder.types.LocalVariable;
import net.amygdalum.testrecorder.types.TypeManager;
import net.amygdalum.testrecorder.util.SerializableParameterizedType;
import net.amygdalum.testrecorder.util.TypeFilters;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedList;

public class CollectionsListAdaptor
implements SetupGenerator<SerializedList> {
    private DefaultListAdaptor adaptor = new DefaultListAdaptor();

    @Override
    public Class<SerializedList> getAdaptedClass() {
        return SerializedList.class;
    }

    @Override
    public Class<? extends SetupGenerator<SerializedList>> parent() {
        return DefaultListAdaptor.class;
    }

    @Override
    public boolean matches(Type type) {
        return Types.innerClasses(Collections.class).stream().filter(TypeFilters.startingWith((String[])new String[]{"Unmodifiable", "Synchronized", "Checked", "Empty", "Singleton"})).filter(element -> List.class.isAssignableFrom((Class<?>)element)).anyMatch(element -> Types.equalBaseTypes((Type)element, (Type)type));
    }

    @Override
    public Computation tryDeserialize(SerializedList value, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        TypeManager types = context.getTypes();
        types.registerImport(List.class);
        types.registerType(value.getComponentType());
        String name = types.getRawTypeName(value.getType());
        if (name.contains("Empty")) {
            return this.tryDeserializeEmpty(value, generator);
        }
        if (name.contains("Singleton")) {
            return this.tryDeserializeSingleton(value, generator);
        }
        if (name.contains("Unmodifiable")) {
            return this.tryDeserializeUnmodifiable(value, generator);
        }
        if (name.contains("Synchronized")) {
            return this.tryDeserializeSynchronized(value, generator);
        }
        if (name.contains("Checked")) {
            return this.tryDeserializeChecked(value, generator);
        }
        throw new DeserializationException("failed deserializing: " + value);
    }

    private Computation createOrdinaryList(SerializedList value, Deserializer generator) {
        SerializedList baseValue = new SerializedList(ArrayList.class);
        baseValue.useAs((Type)Types.parameterized(ArrayList.class, null, (Type[])new Type[]{value.getComponentType()}));
        baseValue.addAll(value);
        return this.adaptor.tryDeserialize(baseValue, generator);
    }

    private Computation tryDeserializeEmpty(SerializedList value, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        Type componentType = value.getComponentType();
        String factoryMethod = "emptyList";
        TypeManager types = context.getTypes();
        types.staticImport(Collections.class, factoryMethod);
        if (types.isHidden(componentType)) {
            componentType = Types.wildcard();
        }
        SerializableParameterizedType resultType = Types.parameterized(List.class, null, (Type[])new Type[]{componentType});
        return context.forVariable(value, (Type)resultType, arg_0 -> CollectionsListAdaptor.lambda$tryDeserializeEmpty$2(types, (Type)resultType, factoryMethod, arg_0));
    }

    private Computation tryDeserializeSingleton(SerializedList value, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        Type componentType = value.getComponentType();
        String factoryMethod = "singletonList";
        TypeManager types = context.getTypes();
        types.registerImport(List.class);
        types.staticImport(Collections.class, factoryMethod);
        if (types.isHidden(componentType)) {
            componentType = Types.wildcard();
        }
        SerializableParameterizedType resultType = Types.parameterized(List.class, null, (Type[])new Type[]{componentType});
        return context.forVariable(value, (Type)resultType, arg_0 -> CollectionsListAdaptor.lambda$tryDeserializeSingleton$3(value, generator, types, (Type)resultType, factoryMethod, arg_0));
    }

    private Computation tryDeserializeUnmodifiable(SerializedList value, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        Type componentType = value.getComponentType();
        String factoryMethod = "unmodifiableList";
        TypeManager types = context.getTypes();
        types.staticImport(Collections.class, factoryMethod);
        if (types.isHidden(componentType)) {
            componentType = Types.wildcard();
        }
        SerializableParameterizedType resultType = Types.parameterized(List.class, null, (Type[])new Type[]{componentType});
        return context.forVariable(value, (Type)resultType, arg_0 -> this.lambda$tryDeserializeUnmodifiable$4(value, generator, types, (Type)resultType, factoryMethod, arg_0));
    }

    private Computation tryDeserializeSynchronized(SerializedList value, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        Type componentType = value.getComponentType();
        String factoryMethod = "synchronizedList";
        TypeManager types = context.getTypes();
        types.staticImport(Collections.class, factoryMethod);
        if (types.isHidden(componentType)) {
            componentType = Types.wildcard();
        }
        SerializableParameterizedType resultType = Types.parameterized(List.class, null, (Type[])new Type[]{componentType});
        return context.forVariable(value, (Type)resultType, arg_0 -> this.lambda$tryDeserializeSynchronized$5(value, generator, types, (Type)resultType, factoryMethod, arg_0));
    }

    private Computation tryDeserializeChecked(SerializedList value, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        Type componentType = value.getComponentType();
        String factoryMethod = "checkedList";
        TypeManager types = context.getTypes();
        types.staticImport(Collections.class, factoryMethod);
        if (types.isHidden(componentType)) {
            throw new DeserializationException("cannot deserialize checked list with hidden element type: " + types.getVariableTypeName(componentType));
        }
        SerializableParameterizedType resultType = Types.parameterized(List.class, null, (Type[])new Type[]{componentType});
        return context.forVariable(value, (Type)resultType, arg_0 -> this.lambda$tryDeserializeChecked$6(value, generator, types, componentType, (Type)resultType, factoryMethod, arg_0));
    }

    private /* synthetic */ Computation lambda$tryDeserializeChecked$6(SerializedList value, Deserializer generator, TypeManager types, Type componentType, Type resultType, String factoryMethod, LocalVariable local) throws DeserializationException {
        Computation computation = this.createOrdinaryList(value, generator);
        LinkedList<String> statements = new LinkedList<String>(computation.getStatements());
        String resultBase = computation.getValue();
        String checkedType = types.getRawClass(componentType);
        String decoratingStatement = Templates.assignLocalVariableStatement(types.getVariableTypeName(resultType), local.getName(), Templates.callLocalMethod(factoryMethod, resultBase, checkedType));
        statements.add(decoratingStatement);
        return Computation.variable(local.getName(), local.getType(), statements);
    }

    private /* synthetic */ Computation lambda$tryDeserializeSynchronized$5(SerializedList value, Deserializer generator, TypeManager types, Type resultType, String factoryMethod, LocalVariable local) throws DeserializationException {
        Computation computation = this.createOrdinaryList(value, generator);
        LinkedList<String> statements = new LinkedList<String>(computation.getStatements());
        String resultBase = computation.getValue();
        String decoratingStatement = Templates.assignLocalVariableStatement(types.getVariableTypeName(resultType), local.getName(), Templates.callLocalMethod(factoryMethod, resultBase));
        statements.add(decoratingStatement);
        return Computation.variable(local.getName(), local.getType(), statements);
    }

    private /* synthetic */ Computation lambda$tryDeserializeUnmodifiable$4(SerializedList value, Deserializer generator, TypeManager types, Type resultType, String factoryMethod, LocalVariable local) throws DeserializationException {
        Computation computation = this.createOrdinaryList(value, generator);
        LinkedList<String> statements = new LinkedList<String>(computation.getStatements());
        String resultBase = computation.getValue();
        String decoratingStatement = Templates.assignLocalVariableStatement(types.getVariableTypeName(resultType), local.getName(), Templates.callLocalMethod(factoryMethod, resultBase));
        statements.add(decoratingStatement);
        return Computation.variable(local.getName(), local.getType(), statements);
    }

    private static /* synthetic */ Computation lambda$tryDeserializeSingleton$3(SerializedList value, Deserializer generator, TypeManager types, Type resultType, String factoryMethod, LocalVariable local) throws DeserializationException {
        Computation computation = value.get(0).accept(generator);
        LinkedList<String> statements = new LinkedList<String>(computation.getStatements());
        String resultBase = computation.getValue();
        String decoratingStatement = Templates.assignLocalVariableStatement(types.getVariableTypeName(resultType), local.getName(), Templates.callLocalMethod(factoryMethod, resultBase));
        statements.add(decoratingStatement);
        return Computation.variable(local.getName(), local.getType(), statements);
    }

    private static /* synthetic */ Computation lambda$tryDeserializeEmpty$2(TypeManager types, Type resultType, String factoryMethod, LocalVariable local) throws DeserializationException {
        String decoratingStatement = Templates.assignLocalVariableStatement(types.getVariableTypeName(resultType), local.getName(), Templates.callLocalMethod(factoryMethod, new String[0]));
        return Computation.variable(local.getName(), local.getType(), Arrays.asList(decoratingStatement));
    }
}

