/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.builder;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import net.amygdalum.testrecorder.deserializers.Deserializer;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.builder.DefaultMapAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.SetupGenerator;
import net.amygdalum.testrecorder.types.Computation;
import net.amygdalum.testrecorder.types.DeserializationException;
import net.amygdalum.testrecorder.types.DeserializerContext;
import net.amygdalum.testrecorder.types.LocalVariable;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.types.TypeManager;
import net.amygdalum.testrecorder.util.SerializableParameterizedType;
import net.amygdalum.testrecorder.util.TypeFilters;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedMap;

public class CollectionsMapAdaptor
implements SetupGenerator<SerializedMap> {
    private DefaultMapAdaptor adaptor = new DefaultMapAdaptor();

    @Override
    public Class<SerializedMap> getAdaptedClass() {
        return SerializedMap.class;
    }

    @Override
    public Class<? extends SetupGenerator<SerializedMap>> parent() {
        return DefaultMapAdaptor.class;
    }

    @Override
    public boolean matches(Type type) {
        return Types.innerClasses(Collections.class).stream().filter(TypeFilters.startingWith((String[])new String[]{"Unmodifiable", "Synchronized", "Checked", "Empty", "Singleton"})).filter(element -> Map.class.isAssignableFrom((Class<?>)element)).anyMatch(element -> Types.equalBaseTypes((Type)element, (Type)type));
    }

    @Override
    public Computation tryDeserialize(SerializedMap value, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        TypeManager types = context.getTypes();
        types.registerImport(Map.class);
        types.registerTypes(value.getMapKeyType(), value.getMapValueType());
        String name = types.getRawTypeName(value.getType());
        if (name.contains("Empty")) {
            return this.tryDeserializeEmpty(value, generator);
        }
        if (name.contains("Singleton")) {
            return this.tryDeserializeSingleton(value, generator);
        }
        if (name.contains("Unmodifiable")) {
            return this.tryDeserializeUnmodifiable(value, generator);
        }
        if (name.contains("Synchronized")) {
            return this.tryDeserializeSynchronized(value, generator);
        }
        if (name.contains("Checked")) {
            return this.tryDeserializeChecked(value, generator);
        }
        throw new DeserializationException("failed deserializing: " + value);
    }

    private Computation createOrdinaryMap(SerializedMap value, Deserializer generator) {
        SerializedMap baseValue = new SerializedMap(LinkedHashMap.class);
        baseValue.useAs((Type)Types.parameterized(LinkedHashMap.class, null, (Type[])new Type[]{value.getMapKeyType(), value.getMapValueType()}));
        baseValue.putAll(value);
        return this.adaptor.tryDeserialize(baseValue, generator);
    }

    private Computation tryDeserializeEmpty(SerializedMap value, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        Type mapKeyType = value.getMapKeyType();
        Type mapValueType = value.getMapValueType();
        String factoryMethod = "emptyMap";
        TypeManager types = context.getTypes();
        types.staticImport(Collections.class, factoryMethod);
        if (types.isHidden(mapKeyType)) {
            mapKeyType = Types.wildcard();
        }
        if (types.isHidden(mapValueType)) {
            mapValueType = Types.wildcard();
        }
        SerializableParameterizedType resultType = Types.parameterized(Map.class, null, (Type[])new Type[]{mapKeyType, mapValueType});
        return context.forVariable(value, (Type)resultType, arg_0 -> CollectionsMapAdaptor.lambda$tryDeserializeEmpty$2(types, (Type)resultType, factoryMethod, arg_0));
    }

    private Computation tryDeserializeSingleton(SerializedMap value, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        Type mapKeyType = value.getMapKeyType();
        Type mapValueType = value.getMapValueType();
        String factoryMethod = "singletonMap";
        TypeManager types = context.getTypes();
        types.registerImport(Map.class);
        types.staticImport(Collections.class, factoryMethod);
        if (types.isHidden(mapKeyType)) {
            mapKeyType = Types.wildcard();
        }
        if (types.isHidden(mapValueType)) {
            mapValueType = Types.wildcard();
        }
        SerializableParameterizedType resultType = Types.parameterized(Map.class, null, (Type[])new Type[]{mapKeyType, mapValueType});
        return context.forVariable(value, (Type)resultType, arg_0 -> CollectionsMapAdaptor.lambda$tryDeserializeSingleton$3(value, generator, types, (Type)resultType, factoryMethod, arg_0));
    }

    private Computation tryDeserializeUnmodifiable(SerializedMap value, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        Type mapKeyType = value.getMapKeyType();
        Type mapValueType = value.getMapValueType();
        String factoryMethod = "unmodifiableMap";
        TypeManager types = context.getTypes();
        types.staticImport(Collections.class, factoryMethod);
        if (types.isHidden(mapKeyType)) {
            mapKeyType = Types.wildcard();
        }
        if (types.isHidden(mapValueType)) {
            mapValueType = Types.wildcard();
        }
        SerializableParameterizedType resultType = Types.parameterized(Map.class, null, (Type[])new Type[]{mapKeyType, mapValueType});
        return context.forVariable(value, (Type)resultType, arg_0 -> this.lambda$tryDeserializeUnmodifiable$4(value, generator, types, (Type)resultType, factoryMethod, arg_0));
    }

    private Computation tryDeserializeSynchronized(SerializedMap value, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        Type mapKeyType = value.getMapKeyType();
        Type mapValueType = value.getMapValueType();
        String factoryMethod = "synchronizedMap";
        TypeManager types = context.getTypes();
        types.staticImport(Collections.class, factoryMethod);
        if (types.isHidden(mapKeyType)) {
            mapKeyType = Types.wildcard();
        }
        if (types.isHidden(mapValueType)) {
            mapValueType = Types.wildcard();
        }
        SerializableParameterizedType resultType = Types.parameterized(Map.class, null, (Type[])new Type[]{mapKeyType, mapValueType});
        return context.forVariable(value, (Type)resultType, arg_0 -> this.lambda$tryDeserializeSynchronized$5(value, generator, types, (Type)resultType, factoryMethod, arg_0));
    }

    private Computation tryDeserializeChecked(SerializedMap value, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        Type mapKeyType = value.getMapKeyType();
        Type mapValueType = value.getMapValueType();
        String factoryMethod = "checkedMap";
        TypeManager types = context.getTypes();
        types.staticImport(Collections.class, factoryMethod);
        if (types.isHidden(mapKeyType)) {
            throw new DeserializationException("cannot deserialize checked map with hidden key type: " + types.getVariableTypeName(mapKeyType));
        }
        if (types.isHidden(mapValueType)) {
            throw new DeserializationException("cannot deserialize checked map with hidden value type: " + types.getVariableTypeName(mapValueType));
        }
        SerializableParameterizedType resultType = Types.parameterized(Map.class, null, (Type[])new Type[]{mapKeyType, mapValueType});
        return context.forVariable(value, (Type)resultType, arg_0 -> this.lambda$tryDeserializeChecked$6(value, generator, types, mapKeyType, mapValueType, (Type)resultType, factoryMethod, arg_0));
    }

    private /* synthetic */ Computation lambda$tryDeserializeChecked$6(SerializedMap value, Deserializer generator, TypeManager types, Type mapKeyType, Type mapValueType, Type resultType, String factoryMethod, LocalVariable local) throws DeserializationException {
        Computation computation = this.createOrdinaryMap(value, generator);
        LinkedList<String> statements = new LinkedList<String>(computation.getStatements());
        String resultBase = computation.getValue();
        String checkedKeyType = types.getRawClass(mapKeyType);
        String checkedValueType = types.getRawClass(mapValueType);
        String decoratingStatement = Templates.assignLocalVariableStatement(types.getVariableTypeName(resultType), local.getName(), Templates.callLocalMethod(factoryMethod, resultBase, checkedKeyType, checkedValueType));
        statements.add(decoratingStatement);
        return Computation.variable(local.getName(), local.getType(), statements);
    }

    private /* synthetic */ Computation lambda$tryDeserializeSynchronized$5(SerializedMap value, Deserializer generator, TypeManager types, Type resultType, String factoryMethod, LocalVariable local) throws DeserializationException {
        Computation computation = this.createOrdinaryMap(value, generator);
        LinkedList<String> statements = new LinkedList<String>(computation.getStatements());
        String resultBase = computation.getValue();
        String decoratingStatement = Templates.assignLocalVariableStatement(types.getVariableTypeName(resultType), local.getName(), Templates.callLocalMethod(factoryMethod, resultBase));
        statements.add(decoratingStatement);
        return Computation.variable(local.getName(), local.getType(), statements);
    }

    private /* synthetic */ Computation lambda$tryDeserializeUnmodifiable$4(SerializedMap value, Deserializer generator, TypeManager types, Type resultType, String factoryMethod, LocalVariable local) throws DeserializationException {
        Computation computation = this.createOrdinaryMap(value, generator);
        LinkedList<String> statements = new LinkedList<String>(computation.getStatements());
        String resultBase = computation.getValue();
        String decoratingStatement = Templates.assignLocalVariableStatement(types.getVariableTypeName(resultType), local.getName(), Templates.callLocalMethod(factoryMethod, resultBase));
        statements.add(decoratingStatement);
        return Computation.variable(local.getName(), local.getType(), statements);
    }

    private static /* synthetic */ Computation lambda$tryDeserializeSingleton$3(SerializedMap value, Deserializer generator, TypeManager types, Type resultType, String factoryMethod, LocalVariable local) throws DeserializationException {
        Map.Entry<SerializedValue, SerializedValue> entry = value.entrySet().iterator().next();
        LinkedList<String> statements = new LinkedList<String>();
        Computation keyComputation = entry.getKey().accept(generator);
        statements.addAll(keyComputation.getStatements());
        String resultKey = keyComputation.getValue();
        Computation valueComputation = entry.getValue().accept(generator);
        statements.addAll(valueComputation.getStatements());
        String resultValue = valueComputation.getValue();
        String decoratingStatement = Templates.assignLocalVariableStatement(types.getVariableTypeName(resultType), local.getName(), Templates.callLocalMethod(factoryMethod, resultKey, resultValue));
        statements.add(decoratingStatement);
        return Computation.variable(local.getName(), local.getType(), statements);
    }

    private static /* synthetic */ Computation lambda$tryDeserializeEmpty$2(TypeManager types, Type resultType, String factoryMethod, LocalVariable local) throws DeserializationException {
        String decoratingStatement = Templates.assignLocalVariableStatement(types.getVariableTypeName(resultType), local.getName(), Templates.callLocalMethod(factoryMethod, new String[0]));
        return Computation.variable(local.getName(), local.getType(), Arrays.asList(decoratingStatement));
    }
}

