/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.builder;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import net.amygdalum.testrecorder.deserializers.Deserializer;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.builder.DefaultSetAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.SetupGenerator;
import net.amygdalum.testrecorder.types.Computation;
import net.amygdalum.testrecorder.types.DeserializationException;
import net.amygdalum.testrecorder.types.DeserializerContext;
import net.amygdalum.testrecorder.types.LocalVariable;
import net.amygdalum.testrecorder.types.TypeManager;
import net.amygdalum.testrecorder.util.SerializableParameterizedType;
import net.amygdalum.testrecorder.util.TypeFilters;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedSet;

public class CollectionsSetAdaptor
implements SetupGenerator<SerializedSet> {
    private DefaultSetAdaptor adaptor = new DefaultSetAdaptor();

    @Override
    public Class<SerializedSet> getAdaptedClass() {
        return SerializedSet.class;
    }

    @Override
    public Class<? extends SetupGenerator<SerializedSet>> parent() {
        return DefaultSetAdaptor.class;
    }

    @Override
    public boolean matches(Type type) {
        return Types.innerClasses(Collections.class).stream().filter(TypeFilters.startingWith((String[])new String[]{"Unmodifiable", "Synchronized", "Checked", "Empty", "Singleton"})).filter(element -> Set.class.isAssignableFrom((Class<?>)element)).anyMatch(element -> Types.equalBaseTypes((Type)element, (Type)type));
    }

    @Override
    public Computation tryDeserialize(SerializedSet value, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        TypeManager types = context.getTypes();
        types.registerImport(Set.class);
        types.registerType(value.getComponentType());
        String name = types.getRawTypeName(value.getType());
        if (name.contains("Empty")) {
            return this.tryDeserializeEmpty(value, generator);
        }
        if (name.contains("Singleton")) {
            return this.tryDeserializeSingleton(value, generator);
        }
        if (name.contains("Unmodifiable")) {
            return this.tryDeserializeUnmodifiable(value, generator);
        }
        if (name.contains("Synchronized")) {
            return this.tryDeserializeSynchronized(value, generator);
        }
        if (name.contains("Checked")) {
            return this.tryDeserializeChecked(value, generator);
        }
        throw new DeserializationException("failed deserializing: " + value);
    }

    private Computation createOrdinarySet(SerializedSet value, Deserializer generator) {
        SerializedSet baseValue = new SerializedSet(LinkedHashSet.class);
        baseValue.useAs((Type)Types.parameterized(LinkedHashSet.class, null, (Type[])new Type[]{value.getComponentType()}));
        baseValue.addAll(value);
        return this.adaptor.tryDeserialize(baseValue, generator);
    }

    private Computation tryDeserializeEmpty(SerializedSet value, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        Type componentType = value.getComponentType();
        String factoryMethod = "emptySet";
        TypeManager types = context.getTypes();
        types.staticImport(Collections.class, factoryMethod);
        if (types.isHidden(componentType)) {
            componentType = Types.wildcard();
        }
        SerializableParameterizedType resultType = Types.parameterized(Set.class, null, (Type[])new Type[]{componentType});
        return context.forVariable(value, (Type)resultType, arg_0 -> CollectionsSetAdaptor.lambda$tryDeserializeEmpty$2(types, (Type)resultType, factoryMethod, arg_0));
    }

    private Computation tryDeserializeSingleton(SerializedSet value, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        Type componentType = value.getComponentType();
        String factoryMethod = "singleton";
        TypeManager types = context.getTypes();
        types.registerImport(Set.class);
        types.staticImport(Collections.class, factoryMethod);
        if (types.isHidden(componentType)) {
            componentType = Types.wildcard();
        }
        SerializableParameterizedType resultType = Types.parameterized(Set.class, null, (Type[])new Type[]{componentType});
        return context.forVariable(value, (Type)resultType, arg_0 -> CollectionsSetAdaptor.lambda$tryDeserializeSingleton$3(value, generator, types, (Type)resultType, factoryMethod, arg_0));
    }

    private Computation tryDeserializeUnmodifiable(SerializedSet value, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        Type componentType = value.getComponentType();
        String factoryMethod = "unmodifiableSet";
        TypeManager types = context.getTypes();
        types.staticImport(Collections.class, factoryMethod);
        if (types.isHidden(componentType)) {
            componentType = Types.wildcard();
        }
        SerializableParameterizedType resultType = Types.parameterized(Set.class, null, (Type[])new Type[]{componentType});
        return context.forVariable(value, (Type)resultType, arg_0 -> this.lambda$tryDeserializeUnmodifiable$4(value, generator, types, (Type)resultType, factoryMethod, arg_0));
    }

    private Computation tryDeserializeSynchronized(SerializedSet value, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        Type componentType = value.getComponentType();
        String factoryMethod = "synchronizedSet";
        TypeManager types = context.getTypes();
        types.staticImport(Collections.class, factoryMethod);
        if (types.isHidden(componentType)) {
            componentType = Types.wildcard();
        }
        SerializableParameterizedType resultType = Types.parameterized(Set.class, null, (Type[])new Type[]{componentType});
        return context.forVariable(value, (Type)resultType, arg_0 -> this.lambda$tryDeserializeSynchronized$5(value, generator, types, (Type)resultType, factoryMethod, arg_0));
    }

    private Computation tryDeserializeChecked(SerializedSet value, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        Type componentType = value.getComponentType();
        String factoryMethod = "checkedSet";
        TypeManager types = context.getTypes();
        types.staticImport(Collections.class, factoryMethod);
        if (types.isHidden(componentType)) {
            throw new DeserializationException("cannot deserialize checked set with hidden element type: " + types.getVariableTypeName(componentType));
        }
        SerializableParameterizedType resultType = Types.parameterized(Set.class, null, (Type[])new Type[]{componentType});
        return context.forVariable(value, (Type)resultType, arg_0 -> this.lambda$tryDeserializeChecked$6(value, generator, types, (Type)resultType, factoryMethod, arg_0));
    }

    private /* synthetic */ Computation lambda$tryDeserializeChecked$6(SerializedSet value, Deserializer generator, TypeManager types, Type resultType, String factoryMethod, LocalVariable local) throws DeserializationException {
        Computation computation = this.createOrdinarySet(value, generator);
        LinkedList<String> statements = new LinkedList<String>(computation.getStatements());
        String resultBase = computation.getValue();
        String checkedType = types.getRawClass(value.getComponentType());
        String decoratingStatement = Templates.assignLocalVariableStatement(types.getVariableTypeName(resultType), local.getName(), Templates.callLocalMethod(factoryMethod, resultBase, checkedType));
        statements.add(decoratingStatement);
        return Computation.variable(local.getName(), local.getType(), statements);
    }

    private /* synthetic */ Computation lambda$tryDeserializeSynchronized$5(SerializedSet value, Deserializer generator, TypeManager types, Type resultType, String factoryMethod, LocalVariable local) throws DeserializationException {
        Computation computation = this.createOrdinarySet(value, generator);
        LinkedList<String> statements = new LinkedList<String>(computation.getStatements());
        String resultBase = computation.getValue();
        String decoratingStatement = Templates.assignLocalVariableStatement(types.getVariableTypeName(resultType), local.getName(), Templates.callLocalMethod(factoryMethod, resultBase));
        statements.add(decoratingStatement);
        return Computation.variable(local.getName(), local.getType(), statements);
    }

    private /* synthetic */ Computation lambda$tryDeserializeUnmodifiable$4(SerializedSet value, Deserializer generator, TypeManager types, Type resultType, String factoryMethod, LocalVariable local) throws DeserializationException {
        Computation computation = this.createOrdinarySet(value, generator);
        LinkedList<String> statements = new LinkedList<String>(computation.getStatements());
        String resultBase = computation.getValue();
        String decoratingStatement = Templates.assignLocalVariableStatement(types.getVariableTypeName(resultType), local.getName(), Templates.callLocalMethod(factoryMethod, resultBase));
        statements.add(decoratingStatement);
        return Computation.variable(local.getName(), local.getType(), statements);
    }

    private static /* synthetic */ Computation lambda$tryDeserializeSingleton$3(SerializedSet value, Deserializer generator, TypeManager types, Type resultType, String factoryMethod, LocalVariable local) throws DeserializationException {
        Computation computation = value.iterator().next().accept(generator);
        LinkedList<String> statements = new LinkedList<String>(computation.getStatements());
        String resultBase = computation.getValue();
        String decoratingStatement = Templates.assignLocalVariableStatement(types.getVariableTypeName(resultType), local.getName(), Templates.callLocalMethod(factoryMethod, resultBase));
        statements.add(decoratingStatement);
        return Computation.variable(local.getName(), local.getType(), statements);
    }

    private static /* synthetic */ Computation lambda$tryDeserializeEmpty$2(TypeManager types, Type resultType, String factoryMethod, LocalVariable local) throws DeserializationException {
        String decoratingStatement = Templates.assignLocalVariableStatement(types.getVariableTypeName(resultType), local.getName(), Templates.callLocalMethod(factoryMethod, new String[0]));
        return Computation.variable(local.getName(), local.getType(), Arrays.asList(decoratingStatement));
    }
}

