/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.builder;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.amygdalum.testrecorder.deserializers.Deserializer;
import net.amygdalum.testrecorder.deserializers.SimpleDeserializer;
import net.amygdalum.testrecorder.deserializers.builder.ConstructionPlan;
import net.amygdalum.testrecorder.deserializers.builder.ConstructorParam;
import net.amygdalum.testrecorder.deserializers.builder.ConstructorParams;
import net.amygdalum.testrecorder.deserializers.builder.SetterParam;
import net.amygdalum.testrecorder.hints.Setter;
import net.amygdalum.testrecorder.runtime.ComparisonStrategy;
import net.amygdalum.testrecorder.runtime.DefaultComparisonStrategy;
import net.amygdalum.testrecorder.runtime.DefaultValue;
import net.amygdalum.testrecorder.runtime.GenericComparison;
import net.amygdalum.testrecorder.runtime.NonDefaultValue;
import net.amygdalum.testrecorder.runtime.SelectedFieldsComparisonStrategy;
import net.amygdalum.testrecorder.types.Computation;
import net.amygdalum.testrecorder.types.DeserializerContext;
import net.amygdalum.testrecorder.types.LocalVariable;
import net.amygdalum.testrecorder.types.SerializedField;
import net.amygdalum.testrecorder.types.SerializedImmutableType;
import net.amygdalum.testrecorder.types.SerializedReferenceType;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.types.TypeManager;
import net.amygdalum.testrecorder.util.Reflections;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedObject;

public class Construction {
    private SimpleDeserializer deserializer;
    private SerializedObject serialized;
    private LocalVariable var;
    private Map<Constructor<?>, List<ConstructorParam>> constructors;
    private List<SetterParam> setters;

    public Construction(DeserializerContext context, LocalVariable var, SerializedObject value) {
        this.deserializer = new SimpleDeserializer(context);
        this.var = var;
        this.serialized = value;
        this.constructors = new HashMap();
        this.setters = new ArrayList<SetterParam>();
    }

    public Computation computeBest(TypeManager types, Deserializer generator) throws InstantiationException {
        Object value = this.serialized.accept(this.deserializer);
        if (types.isHidden(this.serialized.getType())) {
            throw new InstantiationException();
        }
        this.fillOrigins(types);
        List<String> fields = this.getFields();
        return this.computeConstructionPlans().stream().map(plan -> plan.disambiguate(this.constructors.keySet())).filter(plan -> GenericComparison.equals((String)"", (Object)plan.execute(), (Object)value, (ComparisonStrategy)SelectedFieldsComparisonStrategy.comparingFields((Collection)fields).andThen((ComparisonStrategy)DefaultComparisonStrategy.all()))).sorted().findFirst().map(plan -> plan.compute(types, generator)).orElseThrow(() -> new InstantiationException());
    }

    private List<String> getFields() {
        return this.serialized.getFields().stream().map(field -> field.getName()).collect(Collectors.toList());
    }

    private List<ConstructionPlan> computeConstructionPlans() {
        ArrayList<ConstructionPlan> constructionsPlans = new ArrayList<ConstructionPlan>();
        for (Constructor<?> constructor : this.constructors.keySet()) {
            this.computeConstructionPlan(constructor).ifPresent(constructionsPlans::add);
        }
        return constructionsPlans;
    }

    private Optional<ConstructionPlan> computeConstructionPlan(Constructor<?> constructor) {
        HashSet<SerializedField> todo = new HashSet<SerializedField>(this.serialized.getFields());
        ConstructorParams constructorParams = this.computeConstructorParams(constructor, todo);
        ArrayList<SetterParam> setBySetter = new ArrayList<SetterParam>();
        for (SetterParam param : this.setters) {
            SerializedField field = param.getField();
            if (!todo.contains(field)) continue;
            todo.remove(field);
            setBySetter.add(param);
        }
        todo.removeIf(this::isImmutable);
        if (todo.isEmpty()) {
            return Optional.of(new ConstructionPlan(this.var, constructorParams, setBySetter));
        }
        return Optional.empty();
    }

    private boolean isImmutable(SerializedField field) {
        SerializedValue value = field.getValue();
        if (value instanceof SerializedImmutableType) {
            return true;
        }
        if (value instanceof SerializedReferenceType) {
            DeserializerContext context = this.deserializer.getContext();
            if (context.refCount(value) > 1) {
                return false;
            }
            return context.closureOf(value).stream().filter(val -> val instanceof SerializedReferenceType && !(val instanceof SerializedImmutableType)).allMatch(val -> context.refCount((SerializedValue)val) <= 1);
        }
        return true;
    }

    public ConstructorParams computeConstructorParams(Constructor<?> constructor, Set<SerializedField> todo) {
        List<ConstructorParam> setByConstructor = this.constructors.get(constructor);
        for (ConstructorParam param : setByConstructor) {
            todo.remove(param.getField());
        }
        return this.constructorOf(constructor, setByConstructor);
    }

    private ConstructorParams constructorOf(Constructor<?> constructor, List<ConstructorParam> params) {
        ConstructorParams constructorParams = new ConstructorParams(constructor);
        for (ConstructorParam param : params) {
            constructorParams.add(param);
        }
        return constructorParams;
    }

    private void fillOrigins(TypeManager types) {
        this.addStandardConstructor(types);
        this.addSuitableConstructors(types);
        this.applySetters(types);
        this.removeSelfRecursiveConstructions();
    }

    private void addStandardConstructor(TypeManager types) {
        try {
            Constructor constructor = Types.getDeclaredConstructor((Class)Types.baseType(this.serialized.getType()), (Class[])new Class[0]);
            if (types.isHidden(constructor)) {
                return;
            }
            constructor.setAccessible(true);
            this.constructors.put(constructor, new ArrayList());
        }
        catch (ReflectiveOperationException e) {
            return;
        }
    }

    private void addSuitableConstructors(TypeManager types) {
        for (SerializedField field : this.serialized.getFields()) {
            String fieldName = field.getName();
            Object fieldValue = field.getValue().accept(this.deserializer);
            for (Constructor<?> constructor : this.getParameterConstructors(types, this.serialized.getType())) {
                List params = this.constructors.computeIfAbsent(constructor, key -> new ArrayList());
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Class<?> parameterType = parameterTypes[i];
                    if (!this.matches(parameterType, fieldValue)) continue;
                    Object uniqueFieldValue = this.isDefault(parameterType, fieldValue) ? NonDefaultValue.of(parameterType) : fieldValue;
                    Object[] arguments = this.createArguments(uniqueFieldValue, parameterTypes, i);
                    try {
                        Object result = constructor.newInstance(arguments);
                        if (!this.isSet(result, fieldName, uniqueFieldValue)) continue;
                        params.add(new ConstructorParam(constructor, i, field, fieldValue));
                        continue;
                    }
                    catch (ReflectiveOperationException e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private List<Constructor<?>> getParameterConstructors(TypeManager types, Type type) {
        return Arrays.stream(Types.baseType((Type)type).getConstructors()).filter(constructor -> !types.isHidden((Constructor<?>)constructor)).collect(Collectors.toList());
    }

    private List<Object> createBases() {
        return this.constructors.entrySet().stream().map(entry -> this.createBase((Constructor)entry.getKey(), (List)entry.getValue())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Object createBase(Constructor<?> constructor, List<ConstructorParam> params) {
        Object[] arguments = this.createArguments(params, constructor.getParameterTypes());
        try {
            return constructor.newInstance(arguments);
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    private void applySetters(TypeManager types) {
        for (SerializedField field : this.serialized.getFields()) {
            String fieldName = field.getName();
            Object fieldValue = field.getValue().accept(this.deserializer);
            block3: for (Method method : this.getSetterMethods(types, this.serialized.getType(), fieldValue)) {
                for (Object base : this.createBases()) {
                    try {
                        if (this.isSet(base, fieldName, fieldValue)) continue block3;
                        method.invoke(base, fieldValue);
                        if (this.isSet(base, fieldName, fieldValue)) continue;
                    }
                    catch (ReflectiveOperationException e) {}
                    continue block3;
                }
                Type type = Types.resolve((Type)method.getGenericParameterTypes()[0], (Class)Types.baseType(this.serialized.getType()));
                this.setters.add(new SetterParam(method, type, field, fieldValue));
            }
        }
    }

    private List<Method> getSetterMethods(TypeManager types, Type type, Object value) {
        return Arrays.stream(Types.baseType((Type)type).getMethods()).filter(method -> !types.isHidden((Method)method)).filter(method -> this.qualifiesAsSetter((Method)method, value)).collect(Collectors.toList());
    }

    private boolean qualifiesAsSetter(Method method, Object value) {
        if (!method.getName().startsWith("set") && !this.deserializer.getContext().getHint(method, Setter.class).isPresent()) {
            return false;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            return false;
        }
        return this.matches(parameterTypes[0], value);
    }

    private void removeSelfRecursiveConstructions() {
        this.constructors.values().removeIf(params -> params.stream().map(param -> param.getField().getValue()).anyMatch(value -> this.closure((SerializedValue)value).contains(this.serialized)));
    }

    private Set<SerializedValue> closure(SerializedValue root) {
        HashSet<SerializedValue> closure = new HashSet<SerializedValue>();
        LinkedList<SerializedValue> todo = new LinkedList<SerializedValue>();
        todo.add(root);
        while (!todo.isEmpty()) {
            SerializedValue current = (SerializedValue)todo.poll();
            if (closure.contains(current)) continue;
            closure.add(current);
            todo.addAll(current.referencedValues());
        }
        return closure;
    }

    private boolean matches(Class<?> type, Object value) {
        return this.isDefault(type, value) || type.isInstance(value);
    }

    private boolean isDefault(Class<?> type, Object value) {
        return !type.isPrimitive() && value == null || type.isPrimitive() && value != null && DefaultValue.of(type).getClass() == value.getClass();
    }

    private boolean isSet(Object base, String fieldName, Object expectedValue) throws IllegalAccessException {
        try {
            Field field = Types.getDeclaredField(base.getClass(), (String)fieldName);
            return (Boolean)Reflections.accessing((AccessibleObject)field).call(f -> {
                Object foundValue = f.get(base);
                if (foundValue == expectedValue) {
                    return true;
                }
                if (foundValue == null || expectedValue == null) {
                    return false;
                }
                return foundValue.equals(expectedValue);
            });
        }
        catch (ReflectiveOperationException e) {
            return false;
        }
    }

    private Object[] createArguments(Object fieldValue, Class<?>[] parameterTypes, int index) {
        Object[] arguments = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            arguments[i] = i == index ? fieldValue : DefaultValue.of(parameterTypes[i]);
        }
        return arguments;
    }

    private Object[] createArguments(List<ConstructorParam> params, Class<?>[] parameterTypes) {
        Object[] arguments = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            int paramNumber = i;
            arguments[i] = params.stream().filter(param -> param.getParamNumber() == paramNumber).map(param -> param.getValue()).filter(Objects::nonNull).findFirst().orElseGet(() -> DefaultValue.of((Type)parameterTypes[paramNumber]));
        }
        return arguments;
    }
}

