/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.builder;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.amygdalum.testrecorder.deserializers.Deserializer;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.builder.ConstructorParams;
import net.amygdalum.testrecorder.deserializers.builder.SetterParam;
import net.amygdalum.testrecorder.types.Computation;
import net.amygdalum.testrecorder.types.DeserializerContext;
import net.amygdalum.testrecorder.types.LocalVariable;
import net.amygdalum.testrecorder.types.TypeManager;

public class ConstructionPlan
implements Comparable<ConstructionPlan> {
    private LocalVariable var;
    private ConstructorParams constructorParams;
    private List<SetterParam> setterParams;

    public ConstructionPlan(LocalVariable var, ConstructorParams constructorParams, List<SetterParam> setterParams) {
        this.var = var;
        this.constructorParams = constructorParams;
        this.setterParams = setterParams;
    }

    public ConstructionPlan disambiguate(Collection<Constructor<?>> constructors) {
        for (Constructor<?> constructor : constructors) {
            if (!this.constructorParams.hasAmbiguitiesWith(constructor)) continue;
            this.constructorParams.insertTypeCasts();
        }
        return this;
    }

    public Object execute() {
        try {
            Object base = this.constructorParams.apply();
            for (SetterParam param : this.setterParams) {
                param.apply(base);
            }
            return base;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Computation compute(TypeManager types, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        Class<?> clazz = this.constructorParams.getType();
        types.registerTypes(clazz);
        ArrayList<String> statements = new ArrayList<String>();
        List computedParams = this.constructorParams.getParams().stream().map(value -> value.compile(types, generator)).collect(Collectors.toList());
        statements.addAll(computedParams.stream().flatMap(computation -> computation.getStatements().stream()).collect(Collectors.toList()));
        String[] params = (String[])computedParams.stream().map(computation -> computation.getValue()).toArray(String[]::new);
        String bean = Templates.newObject(types.getConstructorTypeName(clazz), params);
        String constructorStatement = Templates.assignLocalVariableStatement(types.getVariableTypeName(clazz), this.var.getName(), bean);
        statements.add(constructorStatement);
        this.var.define(clazz);
        for (SetterParam param : this.setterParams) {
            Computation fieldComputation = param.computeSerializedValue().accept(generator);
            statements.addAll(fieldComputation.getStatements());
            String value2 = context.adapt(fieldComputation.getValue(), param.getType(), fieldComputation.getType());
            String setStatement = Templates.callMethodStatement(this.var.getName(), param.getName(), value2);
            statements.add(setStatement);
        }
        return Computation.variable(this.var.getName(), this.var.getType(), statements);
    }

    @Override
    public int compareTo(ConstructionPlan o) {
        int osetterSize;
        int osize;
        int constructorSize = this.constructorParams.size();
        int oconstructorSize = o.constructorParams.size();
        int setterSize = this.setterParams.size();
        int size = constructorSize + setterSize;
        int compare = size - (osize = oconstructorSize + (osetterSize = o.setterParams.size()));
        if (compare == 0) {
            compare = oconstructorSize - constructorSize;
        }
        if (compare == 0) {
            compare = System.identityHashCode(this) - System.identityHashCode(o);
        }
        return compare;
    }
}

