/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.builder;

import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import net.amygdalum.testrecorder.deserializers.Deserializer;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.runtime.DefaultValue;
import net.amygdalum.testrecorder.types.Computation;
import net.amygdalum.testrecorder.types.DeserializerContext;
import net.amygdalum.testrecorder.types.SerializedField;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.types.TypeManager;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedLiteral;
import net.amygdalum.testrecorder.values.SerializedNull;

public class ConstructorParam {
    private Constructor<?> constructor;
    private int paramNumber;
    private SerializedField field;
    private Object value;
    private Type type;
    private boolean needsCast;

    public ConstructorParam(Constructor<?> constructor, int paramNumber, SerializedField field, Object value) {
        this.constructor = constructor;
        this.paramNumber = paramNumber;
        this.field = field;
        this.value = value;
    }

    public ConstructorParam(Constructor<?> constructor, int paramNumber) {
        this.constructor = constructor;
        this.paramNumber = paramNumber;
    }

    public int getParamNumber() {
        return this.paramNumber;
    }

    public SerializedField getField() {
        return this.field;
    }

    public Object getValue() {
        return this.value;
    }

    public ConstructorParam insertTypeCasts() {
        this.needsCast = true;
        return this;
    }

    public String toString() {
        return this.constructor.toString() + ":" + this.paramNumber + "=" + this.field.getValue() + "=> " + this.field.getName();
    }

    public SerializedValue computeSerializedValue() {
        Object value;
        Object object = value = this.value != null ? this.value : DefaultValue.of((Type)this.type);
        if (this.field == null) {
            if (Types.isLiteral((Type)this.type) && this.type != String.class) {
                return SerializedLiteral.literal(this.type, value);
            }
            SerializedNull nullInstance = SerializedNull.nullInstance();
            if (this.type != null) {
                nullInstance.useAs(this.type);
            }
            return nullInstance;
        }
        return this.field.getValue();
    }

    public ConstructorParam assertType(Type type) {
        this.type = type;
        return this;
    }

    private boolean castNeeded() {
        if (this.needsCast) {
            return true;
        }
        if (this.field == null || this.value == null || this.type == null) {
            return false;
        }
        return !Types.equalGenericTypes((Type)this.type, (Type)this.field.getType());
    }

    public Computation compile(TypeManager types, Deserializer generator) {
        SerializedValue serializedValue = this.computeSerializedValue();
        Computation computation = serializedValue.accept(generator);
        String value = computation.getValue();
        boolean stored = computation.isStored();
        DeserializerContext context = generator.getContext();
        if (context.needsAdaptation(this.type, computation.getType())) {
            value = context.adapt(value, this.type, computation.getType());
            stored = true;
        } else if (this.castNeeded()) {
            value = Templates.cast(types.getVariableTypeName(this.type), value);
            stored = true;
        }
        computation = new Computation(value, this.type, stored, computation.getStatements());
        return computation;
    }
}

