/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.builder;

import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.amygdalum.testrecorder.deserializers.builder.ConstructorParam;

public class ConstructorParams {
    private Constructor<?> constructor;
    private List<ConstructorParam> params;

    public ConstructorParams(Constructor<?> constructor) {
        this.constructor = constructor;
        this.params = ConstructorParams.createInitialParams(constructor);
    }

    public boolean hasAmbiguitiesWith(Constructor<?> constructor) {
        if (constructor.equals(this.constructor)) {
            return false;
        }
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        if (parameterTypes.length != this.params.size()) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            ConstructorParam param = this.params.get(i);
            Object value = param.getValue();
            if (value == null || parameterType.isInstance(value)) continue;
            return false;
        }
        return true;
    }

    private static List<ConstructorParam> createInitialParams(Constructor<?> constructor) {
        int parameterCount = constructor.getParameterCount();
        ArrayList<ConstructorParam> arrayList = new ArrayList<ConstructorParam>(parameterCount);
        for (int i = 0; i < parameterCount; ++i) {
            arrayList.add(new ConstructorParam(constructor, i));
        }
        return arrayList;
    }

    public void add(ConstructorParam param) {
        int index = param.getParamNumber();
        Type type = this.constructor.getGenericParameterTypes()[index];
        param.assertType(type);
        this.params.set(index, param);
    }

    public void insertTypeCasts() {
        for (ConstructorParam param : this.params) {
            param.insertTypeCasts();
        }
    }

    public Object apply() throws ReflectiveOperationException {
        return this.constructor.newInstance(this.getValues());
    }

    public Class<?> getType() {
        return this.constructor.getDeclaringClass();
    }

    public Object[] getValues() {
        return this.params.stream().map(ConstructorParam::getValue).toArray();
    }

    public List<ConstructorParam> getParams() {
        return this.params;
    }

    public int size() {
        return this.params.size();
    }
}

