/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.builder;

import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.deserializers.Deserializer;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.builder.DefaultSetupGenerator;
import net.amygdalum.testrecorder.deserializers.builder.SetupGenerator;
import net.amygdalum.testrecorder.types.Computation;
import net.amygdalum.testrecorder.types.DeserializerContext;
import net.amygdalum.testrecorder.types.TypeManager;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedArray;

public class DefaultArrayAdaptor
extends DefaultSetupGenerator<SerializedArray>
implements SetupGenerator<SerializedArray> {
    @Override
    public Class<SerializedArray> getAdaptedClass() {
        return SerializedArray.class;
    }

    @Override
    public Computation tryDeserialize(SerializedArray value, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        TypeManager types = context.getTypes();
        Type componentType = types.bestType(value.getComponentType(), Object.class);
        types.registerTypes(value.getComponentType(), componentType);
        types.registerTypes(value.getUsedTypes());
        Type usedType = (Type)((Object)types.mostSpecialOf(value.getUsedTypes()).orElse((Type)((Object)Object[].class)));
        return context.forVariable(value, usedType, local -> {
            List elementTemplates = Stream.of(value.getArray()).map(element -> element.accept(generator)).collect(Collectors.toList());
            List<String> elements = elementTemplates.stream().map(template -> context.adapt(template.getValue(), componentType, template.getType())).collect(Collectors.toList());
            List<String> statements = elementTemplates.stream().flatMap(template -> template.getStatements().stream()).collect(Collectors.toList());
            String arrayLiteral = Templates.arrayLiteral(types.getVariableTypeName(Types.array((Type)componentType)), elements);
            statements.add(Templates.assignLocalVariableStatement(types.getVariableTypeName(usedType), local.getName(), arrayLiteral));
            return Computation.variable(local.getName(), local.getType(), statements);
        });
    }
}

