/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.builder;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import net.amygdalum.testrecorder.deserializers.Adaptor;
import net.amygdalum.testrecorder.deserializers.Deserializer;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.builder.DefaultSetupGenerator;
import net.amygdalum.testrecorder.types.Computation;
import net.amygdalum.testrecorder.types.DeserializerContext;
import net.amygdalum.testrecorder.types.TypeManager;
import net.amygdalum.testrecorder.util.Literals;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedImmutable;

public class DefaultBigDecimalAdaptor
extends DefaultSetupGenerator<SerializedImmutable<BigDecimal>>
implements Adaptor<SerializedImmutable<BigDecimal>> {
    @Override
    public Class<SerializedImmutable> getAdaptedClass() {
        return SerializedImmutable.class;
    }

    @Override
    public boolean matches(Type type) {
        return Types.equalBaseTypes((Type)type, BigDecimal.class);
    }

    @Override
    public Computation tryDeserialize(SerializedImmutable<BigDecimal> value, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        TypeManager types = context.getTypes();
        types.registerImport(BigDecimal.class);
        String literal = Literals.asLiteral((String)value.getValue().toPlainString());
        String bigDecimal = Templates.newObject("BigDecimal", literal);
        return Computation.expression(bigDecimal, (Type)((Object)types.mostSpecialOf(value.getUsedTypes()).orElse((Type)((Object)BigDecimal.class))));
    }
}

