/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.builder;

import java.lang.reflect.Type;
import java.math.BigInteger;
import net.amygdalum.testrecorder.deserializers.Adaptor;
import net.amygdalum.testrecorder.deserializers.Deserializer;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.builder.DefaultSetupGenerator;
import net.amygdalum.testrecorder.types.Computation;
import net.amygdalum.testrecorder.types.DeserializerContext;
import net.amygdalum.testrecorder.types.TypeManager;
import net.amygdalum.testrecorder.util.Literals;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedImmutable;

public class DefaultBigIntegerAdaptor
extends DefaultSetupGenerator<SerializedImmutable<BigInteger>>
implements Adaptor<SerializedImmutable<BigInteger>> {
    @Override
    public Class<SerializedImmutable> getAdaptedClass() {
        return SerializedImmutable.class;
    }

    @Override
    public boolean matches(Type type) {
        return Types.equalBaseTypes((Type)type, BigInteger.class);
    }

    @Override
    public Computation tryDeserialize(SerializedImmutable<BigInteger> value, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        TypeManager types = context.getTypes();
        types.registerImport(BigInteger.class);
        String literal = Literals.asLiteral((String)value.getValue().toString());
        String bigInteger = Templates.newObject("BigInteger", literal);
        return Computation.expression(bigInteger, (Type)((Object)types.mostSpecialOf(value.getUsedTypes()).orElse((Type)((Object)BigInteger.class))));
    }
}

