/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.builder;

import java.lang.reflect.Type;
import net.amygdalum.testrecorder.deserializers.Adaptor;
import net.amygdalum.testrecorder.deserializers.Deserializer;
import net.amygdalum.testrecorder.deserializers.builder.DefaultSetupGenerator;
import net.amygdalum.testrecorder.types.Computation;
import net.amygdalum.testrecorder.types.DeserializerContext;
import net.amygdalum.testrecorder.types.TypeManager;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedImmutable;

public class DefaultClassAdaptor
extends DefaultSetupGenerator<SerializedImmutable<Class<?>>>
implements Adaptor<SerializedImmutable<Class<?>>> {
    @Override
    public Class<SerializedImmutable> getAdaptedClass() {
        return SerializedImmutable.class;
    }

    @Override
    public boolean matches(Type type) {
        return Types.equalBaseTypes((Type)type, Class.class);
    }

    @Override
    public Computation tryDeserialize(SerializedImmutable<Class<?>> value, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        TypeManager types = context.getTypes();
        types.registerImport(Class.class);
        Class<?> clazz = value.getValue();
        return Computation.expression(types.getRawClass(clazz), (Type)((Object)types.mostSpecialOf(value.getUsedTypes()).orElse((Type)((Object)Class.class))));
    }
}

