/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.builder;

import java.lang.reflect.Type;
import net.amygdalum.testrecorder.deserializers.Deserializer;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.builder.DefaultSetupGenerator;
import net.amygdalum.testrecorder.deserializers.builder.SetupGenerator;
import net.amygdalum.testrecorder.runtime.Wrapped;
import net.amygdalum.testrecorder.types.Computation;
import net.amygdalum.testrecorder.types.DeserializerContext;
import net.amygdalum.testrecorder.types.TypeManager;
import net.amygdalum.testrecorder.util.Literals;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedEnum;

public class DefaultEnumAdaptor
extends DefaultSetupGenerator<SerializedEnum>
implements SetupGenerator<SerializedEnum> {
    @Override
    public Class<SerializedEnum> getAdaptedClass() {
        return SerializedEnum.class;
    }

    @Override
    public boolean matches(Type type) {
        return Types.baseType((Type)type).isEnum();
    }

    @Override
    public Computation tryDeserialize(SerializedEnum value, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        TypeManager types = context.getTypes();
        types.registerType(value.getType());
        Type usedType = (Type)((Object)types.mostSpecialOf(value.getUsedTypes()).orElse((Type)((Object)Enum.class)));
        if (types.isHidden(value.getType())) {
            String typeName = Types.baseType(value.getType()).getName();
            String typeArgument = Literals.asLiteral((String)typeName);
            String expression = Templates.callMethod(types.getRawTypeName((Type)((Object)Wrapped.class)), "enumType", typeArgument, Literals.asLiteral((String)value.getName()));
            expression = context.adapt(expression, usedType, value.getType());
            return Computation.expression(expression, usedType);
        }
        String typeName = types.getVariableTypeName(value.getType());
        String name = value.getName();
        String enumConstant = Templates.fieldAccess(typeName, name);
        return Computation.expression(enumConstant, usedType);
    }
}

