/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.builder;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.deserializers.Deserializer;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.builder.DefaultSetupGenerator;
import net.amygdalum.testrecorder.deserializers.builder.SetupGenerator;
import net.amygdalum.testrecorder.types.Computation;
import net.amygdalum.testrecorder.types.DeserializerContext;
import net.amygdalum.testrecorder.types.SerializedReferenceType;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.types.TypeManager;
import net.amygdalum.testrecorder.util.Types;

public abstract class DefaultGenericCollectionAdaptor<T extends SerializedReferenceType>
extends DefaultSetupGenerator<T>
implements SetupGenerator<T> {
    public abstract Class<?>[] matchingTypes();

    public abstract Type componentType(T var1);

    public abstract Stream<SerializedValue> elements(T var1);

    @Override
    public boolean matches(Type type) {
        return this.matchType(type).isPresent();
    }

    public Optional<Class<?>> matchType(Type type) {
        return Stream.of(this.matchingTypes()).filter(clazz -> clazz.isAssignableFrom(Types.baseType((Type)type))).findFirst();
    }

    @Override
    public Computation tryDeserialize(T value, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        TypeManager types = context.getTypes();
        Class<?> type = value.getType();
        Type usedType = (Type)((Object)types.mostSpecialOf(value.getUsedTypes()).orElse((Type)((Object)Object.class)));
        boolean uniqueUsageType = value.getUsedTypes().length == 1 && Collection.class.isAssignableFrom(Types.baseType((Type)usedType));
        Type componentType = this.componentType(value);
        Class<?> matchingType = this.matchType(type).get();
        Type effectiveResultType = types.bestType(usedType, matchingType);
        Type temporaryType = uniqueUsageType ? effectiveResultType : types.bestType(type, effectiveResultType, matchingType);
        Type componentResultType = types.isHidden(componentType) ? (Type)((Object)Types.typeArgument((Type)temporaryType, (int)0).orElse(Object.class)) : componentType;
        types.registerTypes(effectiveResultType, type, componentResultType);
        return context.forVariable((SerializedValue)value, effectiveResultType, local -> {
            List elementTemplates = this.elements(value).map(element -> element.accept(generator)).filter(element -> element != null).collect(Collectors.toList());
            List elements = elementTemplates.stream().map(template -> context.adapt(template.getValue(), componentResultType, template.getType())).collect(Collectors.toList());
            List<String> statements = elementTemplates.stream().flatMap(template -> template.getStatements().stream()).collect(Collectors.toList());
            String tempVar = local.getName();
            if (!Types.equalGenericTypes((Type)effectiveResultType, (Type)temporaryType)) {
                tempVar = context.temporaryLocal();
            }
            String set = types.isHidden(type) ? context.adapt(types.getWrappedName(type), temporaryType, types.wrapHidden(type)) : Templates.newObject(types.getConstructorTypeName(type), new String[0]);
            String temporaryTypeName = Optional.of(temporaryType).filter(t -> Types.typeArguments((Type)t).count() > 0L).filter(t -> Types.typeArguments((Type)t).allMatch(Types::isBound)).map(t -> types.getVariableTypeName((Type)t)).orElse(types.getRawTypeName(temporaryType));
            String setInit = Templates.assignLocalVariableStatement(temporaryTypeName, tempVar, set);
            statements.add(setInit);
            for (String element2 : elements) {
                String addElement = Templates.callMethodStatement(tempVar, "add", element2);
                statements.add(addElement);
            }
            if (local.isDefined() && !local.isReady()) {
                statements.add(Templates.callMethodStatement(local.getName(), "addAll", tempVar));
            } else if (context.needsAdaptation(effectiveResultType, temporaryType)) {
                tempVar = context.adapt(tempVar, effectiveResultType, temporaryType);
                statements.add(Templates.assignLocalVariableStatement(types.getVariableTypeName(effectiveResultType), local.getName(), tempVar));
            } else if (!Types.equalGenericTypes((Type)effectiveResultType, (Type)temporaryType)) {
                statements.add(Templates.assignLocalVariableStatement(types.getVariableTypeName(effectiveResultType), local.getName(), tempVar));
            }
            return Computation.variable(local.getName(), local.getType(), statements);
        });
    }
}

