/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.builder;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.deserializers.Deserializer;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.builder.DefaultSetupGenerator;
import net.amygdalum.testrecorder.deserializers.builder.SetupGenerator;
import net.amygdalum.testrecorder.types.Computation;
import net.amygdalum.testrecorder.types.DeserializerContext;
import net.amygdalum.testrecorder.types.SerializedReferenceType;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.types.TypeManager;
import net.amygdalum.testrecorder.util.Pair;
import net.amygdalum.testrecorder.util.Types;

public abstract class DefaultGenericMapAdaptor<T extends SerializedReferenceType>
extends DefaultSetupGenerator<T>
implements SetupGenerator<T> {
    public abstract Class<?>[] matchingTypes();

    public abstract Type keyType(T var1);

    public abstract Type valueType(T var1);

    public abstract Stream<Pair<SerializedValue, SerializedValue>> entries(T var1);

    @Override
    public boolean matches(Type type) {
        return this.matchType(type).isPresent();
    }

    public Optional<Class<?>> matchType(Type type) {
        return Stream.of(this.matchingTypes()).filter(clazz -> clazz.isAssignableFrom(Types.baseType((Type)type))).findFirst();
    }

    @Override
    public Computation tryDeserialize(T value, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        TypeManager types = context.getTypes();
        Class<?> type = value.getType();
        Type usedType = (Type)((Object)types.mostSpecialOf(value.getUsedTypes()).orElse((Type)((Object)Object.class)));
        boolean uniqueUsageType = value.getUsedTypes().length == 1 && Map.class.isAssignableFrom(Types.baseType((Type)usedType));
        Type mapKeyType = this.keyType(value);
        Type mapValueType = this.valueType(value);
        Class<?> matchingType = this.matchType(type).get();
        Type effectiveResultType = types.bestType(usedType, matchingType);
        Type temporaryType = uniqueUsageType ? effectiveResultType : types.bestType(type, effectiveResultType, matchingType);
        Type keyResultType = types.isHidden(mapKeyType) ? (Type)((Object)Types.typeArgument((Type)temporaryType, (int)0).orElse(Object.class)) : mapKeyType;
        Type valueResultType = types.isHidden(mapValueType) ? (Type)((Object)Types.typeArgument((Type)temporaryType, (int)1).orElse(Object.class)) : mapValueType;
        types.registerTypes(effectiveResultType, temporaryType, type, keyResultType, valueResultType);
        return context.forVariable((SerializedValue)value, effectiveResultType, local -> {
            List elementTemplates = this.entries(value).map(entry -> new Pair((Object)((SerializedValue)entry.getElement1()).accept(generator), (Object)((SerializedValue)entry.getElement2()).accept(generator))).filter(pair -> pair.getElement1() != null && pair.getElement2() != null).collect(Collectors.toList());
            List elements = elementTemplates.stream().map(pair -> new Pair((Object)context.adapt(((Computation)pair.getElement1()).getValue(), keyResultType, ((Computation)pair.getElement1()).getType()), (Object)context.adapt(((Computation)pair.getElement2()).getValue(), valueResultType, ((Computation)pair.getElement2()).getType()))).collect(Collectors.toList());
            List<String> statements = elementTemplates.stream().flatMap(pair -> Stream.concat(((Computation)pair.getElement1()).getStatements().stream(), ((Computation)pair.getElement2()).getStatements().stream())).collect(Collectors.toList());
            String tempVar = local.getName();
            if (!Types.equalBaseTypes((Type)effectiveResultType, (Type)temporaryType)) {
                tempVar = context.temporaryLocal();
            }
            String map = types.isHidden(type) ? context.adapt(types.getWrappedName(type), temporaryType, types.wrapHidden(type)) : Templates.newObject(types.getConstructorTypeName(type), new String[0]);
            String temporaryTypeName = Optional.of(temporaryType).filter(t -> Types.typeArguments((Type)t).count() > 0L).filter(t -> Types.typeArguments((Type)t).allMatch(Types::isBound)).map(t -> types.getVariableTypeName((Type)t)).orElse(types.getRawTypeName(temporaryType));
            String mapInit = Templates.assignLocalVariableStatement(temporaryTypeName, tempVar, map);
            statements.add(mapInit);
            for (Pair element : elements) {
                String putEntry = Templates.callMethodStatement(tempVar, "put", (String)element.getElement1(), (String)element.getElement2());
                statements.add(putEntry);
            }
            if (local.isDefined() && !local.isReady()) {
                statements.add(Templates.callMethodStatement(local.getName(), "putAll", tempVar));
            } else if (context.needsAdaptation(effectiveResultType, temporaryType)) {
                tempVar = context.adapt(tempVar, effectiveResultType, temporaryType);
                statements.add(Templates.assignLocalVariableStatement(types.getVariableTypeName(effectiveResultType), local.getName(), tempVar));
            } else if (!Types.equalBaseTypes((Type)effectiveResultType, (Type)temporaryType)) {
                statements.add(Templates.assignLocalVariableStatement(types.getVariableTypeName(effectiveResultType), local.getName(), tempVar));
            }
            return Computation.variable(local.getName(), local.getType(), statements);
        });
    }
}

