/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.builder;

import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import net.amygdalum.testrecorder.deserializers.Deserializer;
import net.amygdalum.testrecorder.deserializers.FieldNamingStrategy;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.builder.DefaultSetupGenerator;
import net.amygdalum.testrecorder.deserializers.builder.SetupGenerator;
import net.amygdalum.testrecorder.runtime.GenericObject;
import net.amygdalum.testrecorder.types.Computation;
import net.amygdalum.testrecorder.types.DeserializerContext;
import net.amygdalum.testrecorder.types.TypeManager;
import net.amygdalum.testrecorder.values.SerializedObject;

public class DefaultObjectAdaptor
extends DefaultSetupGenerator<SerializedObject>
implements SetupGenerator<SerializedObject> {
    @Override
    public Class<SerializedObject> getAdaptedClass() {
        return SerializedObject.class;
    }

    @Override
    public Computation tryDeserialize(SerializedObject value, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        TypeManager types = context.getTypes();
        types.registerTypes(new Type[]{value.getType(), GenericObject.class});
        types.registerTypes(value.getUsedTypes());
        Class<?> type = value.getType();
        Type usedType = (Type)((Object)types.mostSpecialOf(value.getUsedTypes()).orElse((Type)((Object)Object.class)));
        return context.forVariable(value, usedType, local -> {
            List elementTemplates = FieldNamingStrategy.ensureUniqueNames(value.getFields()).stream().sorted().map(field -> field.accept(generator)).collect(Collectors.toList());
            List<String> elements = elementTemplates.stream().map(template -> template.getValue()).collect(Collectors.toList());
            List<String> statements = elementTemplates.stream().flatMap(template -> template.getStatements().stream()).collect(Collectors.toList());
            Type effectiveResultType = usedType;
            if (local.isDefined() && !local.isReady()) {
                effectiveResultType = local.getType();
                String genericObject = Templates.genericObject(types.getRawClass(type), elements);
                statements.add(Templates.callMethodStatement(types.getVariableTypeName((Type)((Object)GenericObject.class)), "define", local.getName(), genericObject));
            } else {
                effectiveResultType = types.wrapHidden(usedType);
                String genericObject = Templates.genericObjectConverter(types.getRawClass(type), elements);
                genericObject = context.adapt(genericObject, effectiveResultType, type);
                statements.add(Templates.assignLocalVariableStatement(types.getRawTypeName(effectiveResultType), local.getName(), genericObject));
            }
            return Computation.variable(local.getName(), local.getType(), statements);
        });
    }
}

