/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.builder;

import java.lang.reflect.Type;
import net.amygdalum.testrecorder.deserializers.Deserializer;
import net.amygdalum.testrecorder.deserializers.builder.DefaultObjectAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.FactoryConstruction;
import net.amygdalum.testrecorder.deserializers.builder.SetupGenerator;
import net.amygdalum.testrecorder.types.Computation;
import net.amygdalum.testrecorder.types.DeserializationException;
import net.amygdalum.testrecorder.types.DeserializerContext;
import net.amygdalum.testrecorder.types.TypeManager;
import net.amygdalum.testrecorder.values.SerializedObject;

public class ObjectFactoryAdaptor
implements SetupGenerator<SerializedObject> {
    @Override
    public Class<SerializedObject> getAdaptedClass() {
        return SerializedObject.class;
    }

    @Override
    public Class<? extends SetupGenerator<SerializedObject>> parent() {
        return DefaultObjectAdaptor.class;
    }

    @Override
    public boolean matches(Type type) {
        return true;
    }

    @Override
    public Computation tryDeserialize(SerializedObject value, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        TypeManager types = context.getTypes();
        Class<?> type = types.isHidden(value.getType()) ? (Type)((Object)types.mostSpecialOf(value.getUsedTypes()).orElse((Type)((Object)Object.class))) : value.getType();
        return context.forVariable(value, type, local -> {
            try {
                return new FactoryConstruction(context, local, value).build(types, generator);
            }
            catch (ReflectiveOperationException | RuntimeException e) {
                throw new DeserializationException("failed deserializing with builder conventions: " + value, e);
            }
        });
    }
}

