/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.builder;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.amygdalum.testrecorder.deserializers.Adaptors;
import net.amygdalum.testrecorder.deserializers.Deserializer;
import net.amygdalum.testrecorder.deserializers.DeserializerFactory;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.builder.SetupGenerator;
import net.amygdalum.testrecorder.profile.AgentConfiguration;
import net.amygdalum.testrecorder.runtime.GenericObject;
import net.amygdalum.testrecorder.types.Computation;
import net.amygdalum.testrecorder.types.DeserializerContext;
import net.amygdalum.testrecorder.types.LocalVariable;
import net.amygdalum.testrecorder.types.SerializedArgument;
import net.amygdalum.testrecorder.types.SerializedField;
import net.amygdalum.testrecorder.types.SerializedImmutableType;
import net.amygdalum.testrecorder.types.SerializedReferenceType;
import net.amygdalum.testrecorder.types.SerializedResult;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.types.SerializedValueType;
import net.amygdalum.testrecorder.types.TypeManager;
import net.amygdalum.testrecorder.util.Types;

public class SetupGenerators
implements DeserializerFactory {
    private Adaptors adaptors;

    public SetupGenerators(AgentConfiguration config) {
        this(new Adaptors().load(config.loadConfigurations(SetupGenerator.class, new Object[0])));
    }

    public SetupGenerators(Adaptors adaptors) {
        this.adaptors = adaptors;
    }

    @Override
    public Generator newGenerator(DeserializerContext context) {
        return new Generator(this.adaptors, context);
    }

    public static class Generator
    implements Deserializer {
        private Adaptors adaptors;
        private DeserializerContext context;

        public Generator(Adaptors adaptors, DeserializerContext context) {
            this.adaptors = adaptors;
            this.context = context;
        }

        @Override
        public DeserializerContext getContext() {
            return this.context;
        }

        @Override
        public Computation visitField(SerializedField field) {
            return this.context.withRole(field, this::generateField);
        }

        private Computation generateField(SerializedField field) {
            TypeManager types = this.context.getTypes();
            Type fieldType = field.getType();
            Type usedType = (Type)((Object)types.mostSpecialOf(field.getValue().getUsedTypes()).orElse((Type)((Object)Object.class)));
            Type fieldResultType = types.bestType(fieldType, Object.class);
            types.registerTypes(fieldType, usedType, fieldResultType);
            SerializedValue value = field.getValue();
            if (value instanceof SerializedReferenceType) {
                ((SerializedReferenceType)value).useAs(Types.serializableOf((Type)fieldResultType));
            }
            Computation valueTemplate = value.accept(this);
            List<String> statements = valueTemplate.getStatements();
            String expression = valueTemplate.getValue();
            expression = this.context.adapt(expression, fieldResultType, valueTemplate.getType());
            String assignField = Templates.fieldDeclaration(null, types.getVariableTypeName(fieldResultType), field.getName(), expression);
            return Computation.expression(assignField, null, statements);
        }

        @Override
        public Computation visitArgument(SerializedArgument argument) {
            return this.context.withRole(argument, this::generateArgument);
        }

        private Computation generateArgument(SerializedArgument argument) {
            SerializedValue argumentValue = argument.getValue();
            return argumentValue.accept(this);
        }

        @Override
        public Computation visitResult(SerializedResult result) {
            return this.context.withRole(result, this::generateResult);
        }

        private Computation generateResult(SerializedResult result) {
            SerializedValue resultValue = result.getValue();
            return resultValue.accept(this);
        }

        @Override
        public Computation visitReferenceType(SerializedReferenceType value) {
            return this.context.withRole(value, this::generateReferenceType);
        }

        private Computation generateReferenceType(SerializedReferenceType value) {
            TypeManager types = this.context.getTypes();
            if (this.context.defines(value)) {
                LocalVariable definition = this.context.getDefinition(value);
                String name = definition.getName();
                if (definition.isDefined()) {
                    return Computation.variable(name, definition.getType());
                }
                ArrayList<String> statements = new ArrayList<String>();
                String forwardExpression = Templates.callMethod(types.getVariableTypeName((Type)((Object)GenericObject.class)), "forward", types.getRawClass(value.getType()));
                Type resultType = types.wrapHidden(value.getType());
                statements.add(Templates.assignLocalVariableStatement(types.getRawTypeName(resultType), name, forwardExpression));
                definition.define(resultType);
                return Computation.variable(name, resultType, statements);
            }
            return this.adaptors.tryDeserialize(value, types, this);
        }

        @Override
        public Computation visitValueType(SerializedValueType value) {
            return this.context.withRole(value, this::generateValueType);
        }

        private Computation generateValueType(SerializedValueType value) {
            TypeManager types = this.context.getTypes();
            return this.adaptors.tryDeserialize(value, types, this);
        }

        @Override
        public Computation visitImmutableType(SerializedImmutableType value) {
            return this.context.withRole(value, this::generateImmutableType);
        }

        private Computation generateImmutableType(SerializedImmutableType value) {
            TypeManager types = this.context.getTypes();
            return this.adaptors.tryDeserialize(value, types, this);
        }
    }
}

