/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.matcher;

import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.deserializers.Deserializer;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.matcher.DefaultMatcherGenerator;
import net.amygdalum.testrecorder.deserializers.matcher.MatcherGenerator;
import net.amygdalum.testrecorder.deserializers.matcher.SimpleValueAdaptor;
import net.amygdalum.testrecorder.runtime.ArrayMatcher;
import net.amygdalum.testrecorder.runtime.PrimitiveArrayMatcher;
import net.amygdalum.testrecorder.types.Computation;
import net.amygdalum.testrecorder.types.DeserializerContext;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.types.TypeManager;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedArray;
import org.hamcrest.Matcher;

public class DefaultArrayAdaptor
extends DefaultMatcherGenerator<SerializedArray>
implements MatcherGenerator<SerializedArray> {
    private SimpleValueAdaptor simpleAdaptor = new SimpleValueAdaptor();

    @Override
    public Class<SerializedArray> getAdaptedClass() {
        return SerializedArray.class;
    }

    @Override
    public Computation tryDeserialize(SerializedArray value, Deserializer generator) {
        Object componentType;
        DeserializerContext context = generator.getContext();
        TypeManager types = context.getTypes();
        if (types.isHidden((Type)(componentType = value.getComponentType()))) {
            componentType = Object.class;
        }
        if (Types.isPrimitive((Type)componentType)) {
            String name = componentType.getTypeName();
            if (value.getArrayAsList().isEmpty()) {
                types.staticImport(PrimitiveArrayMatcher.class, name + "EmptyArray");
                String arrayEmptyMatcher = Templates.primitiveArrayEmptyMatcher(name);
                return Computation.expression(arrayEmptyMatcher, (Type)Types.parameterized(Matcher.class, null, (Type[])new Type[]{Types.wildcard()}));
            }
            types.staticImport(PrimitiveArrayMatcher.class, name + "ArrayContaining");
            List elements = Stream.of(value.getArray()).map(element -> this.simpleAdaptor.tryDeserialize((SerializedValue)element, generator)).collect(Collectors.toList());
            List<String> elementComputations = elements.stream().flatMap(element -> element.getStatements().stream()).collect(Collectors.toList());
            String[] elementValues = (String[])elements.stream().map(element -> element.getValue()).toArray(String[]::new);
            String primitiveArrayContainingMatcher = Templates.primitiveArrayContainingMatcher(name, elementValues);
            return Computation.expression(primitiveArrayContainingMatcher, (Type)Types.parameterized(Matcher.class, null, (Type[])new Type[]{Types.wildcard()}), elementComputations);
        }
        if (value.getArrayAsList().isEmpty()) {
            types.staticImport(ArrayMatcher.class, "emptyArray");
            String arrayEmptyMatcher = Templates.arrayEmptyMatcher();
            return Computation.expression(arrayEmptyMatcher, (Type)Types.parameterized(Matcher.class, null, (Type[])new Type[]{Types.wildcard()}));
        }
        types.staticImport(ArrayMatcher.class, "arrayContaining");
        String name = types.getRawClass((Type)componentType);
        List elements = Stream.of(value.getArray()).map(element -> this.simpleAdaptor.tryDeserialize((SerializedValue)element, generator)).collect(Collectors.toList());
        List<String> elementComputations = elements.stream().flatMap(element -> element.getStatements().stream()).collect(Collectors.toList());
        String[] elementValues = (String[])elements.stream().map(element -> element.getValue()).toArray(String[]::new);
        String arrayContainingMatcher = Templates.arrayContainingMatcher(name, elementValues);
        return Computation.expression(arrayContainingMatcher, (Type)Types.parameterized(Matcher.class, null, (Type[])new Type[]{Types.wildcard()}), elementComputations);
    }
}

