/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.matcher;

import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.Collections;
import net.amygdalum.testrecorder.deserializers.Deserializer;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.matcher.DefaultMatcherGenerator;
import net.amygdalum.testrecorder.deserializers.matcher.MatcherGenerator;
import net.amygdalum.testrecorder.types.Computation;
import net.amygdalum.testrecorder.types.DeserializerContext;
import net.amygdalum.testrecorder.types.TypeManager;
import net.amygdalum.testrecorder.util.Literals;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedImmutable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class DefaultBigIntegerAdaptor
extends DefaultMatcherGenerator<SerializedImmutable<BigInteger>>
implements MatcherGenerator<SerializedImmutable<BigInteger>> {
    @Override
    public Class<SerializedImmutable> getAdaptedClass() {
        return SerializedImmutable.class;
    }

    @Override
    public boolean matches(Type type) {
        return Types.equalBaseTypes((Type)type, BigInteger.class);
    }

    @Override
    public Computation tryDeserialize(SerializedImmutable<BigInteger> value, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        TypeManager types = context.getTypes();
        types.registerImport(BigInteger.class);
        types.staticImport(CoreMatchers.class, "equalTo");
        String literal = Literals.asLiteral((String)value.getValue().toString());
        String bigIntegerLiteral = Templates.newObject("BigInteger", literal);
        String equalToMatcher = Templates.equalToMatcher(bigIntegerLiteral);
        return Computation.expression(equalToMatcher, (Type)Types.parameterized(Matcher.class, null, (Type[])new Type[]{value.getType()}), Collections.emptyList());
    }
}

