/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.matcher;

import java.lang.reflect.Type;
import java.util.Collections;
import net.amygdalum.testrecorder.deserializers.Deserializer;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.matcher.DefaultMatcherGenerator;
import net.amygdalum.testrecorder.deserializers.matcher.MatcherGenerator;
import net.amygdalum.testrecorder.types.Computation;
import net.amygdalum.testrecorder.types.DeserializerContext;
import net.amygdalum.testrecorder.types.TypeManager;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedImmutable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class DefaultClassAdaptor
extends DefaultMatcherGenerator<SerializedImmutable<Class<?>>>
implements MatcherGenerator<SerializedImmutable<Class<?>>> {
    @Override
    public Class<SerializedImmutable> getAdaptedClass() {
        return SerializedImmutable.class;
    }

    @Override
    public boolean matches(Type type) {
        return Types.equalBaseTypes((Type)type, Class.class);
    }

    @Override
    public Computation tryDeserialize(SerializedImmutable<Class<?>> value, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        TypeManager types = context.getTypes();
        types.registerImport(Class.class);
        types.staticImport(CoreMatchers.class, "equalTo");
        Class<?> clazz = value.getValue();
        String equalToMatcher = Templates.equalToMatcher(types.getRawClass(clazz));
        return Computation.expression(equalToMatcher, (Type)Types.parameterized(Matcher.class, null, (Type[])new Type[]{value.getType()}), Collections.emptyList());
    }
}

