/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.matcher;

import java.lang.reflect.Type;
import java.util.Collections;
import net.amygdalum.testrecorder.deserializers.Deserializer;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.matcher.DefaultMatcherGenerator;
import net.amygdalum.testrecorder.deserializers.matcher.MatcherGenerator;
import net.amygdalum.testrecorder.runtime.EnumMatcher;
import net.amygdalum.testrecorder.runtime.WideningMatcher;
import net.amygdalum.testrecorder.types.Computation;
import net.amygdalum.testrecorder.types.DeserializerContext;
import net.amygdalum.testrecorder.types.TypeManager;
import net.amygdalum.testrecorder.util.Literals;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedEnum;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class DefaultEnumAdaptor
extends DefaultMatcherGenerator<SerializedEnum>
implements MatcherGenerator<SerializedEnum> {
    @Override
    public Class<SerializedEnum> getAdaptedClass() {
        return SerializedEnum.class;
    }

    @Override
    public boolean matches(Type type) {
        return Types.baseType((Type)type).isEnum();
    }

    @Override
    public Computation tryDeserialize(SerializedEnum value, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        TypeManager types = context.getTypes();
        Class<?> type = value.getType();
        types.registerType(type);
        Type usedType = types.mostSpecialOf(value.getUsedTypes()).orElse(type);
        if (types.isHidden(type)) {
            if (!Enum.class.isAssignableFrom(Types.baseType((Type)usedType))) {
                types.staticImport(WideningMatcher.class, "widening");
            }
            types.staticImport(EnumMatcher.class, "matchingEnum");
        } else {
            types.staticImport(CoreMatchers.class, "sameInstance");
        }
        if (types.isHidden(type)) {
            String enumMatcher = Templates.enumMatcher(Literals.asLiteral((String)value.getName()));
            if (!Enum.class.isAssignableFrom(Types.baseType((Type)usedType))) {
                enumMatcher = Templates.widening(enumMatcher);
            }
            return Computation.expression(enumMatcher, (Type)Types.parameterized(Matcher.class, null, (Type[])new Type[]{Types.wildcardExtends((Type[])new Type[]{Enum.class})}), Collections.emptyList());
        }
        String typeName = types.getVariableTypeName(type);
        String name = value.getName();
        String matchingValue = Templates.fieldAccess(typeName, name);
        String enumMatcher = Templates.sameInstanceMatcher(matchingValue);
        return Computation.expression(enumMatcher, (Type)Types.parameterized(Matcher.class, null, (Type[])new Type[]{type}), Collections.emptyList());
    }
}

