/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.matcher;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.deserializers.Deserializer;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.matcher.DefaultMatcherGenerator;
import net.amygdalum.testrecorder.deserializers.matcher.MatcherGenerator;
import net.amygdalum.testrecorder.deserializers.matcher.SimpleValueAdaptor;
import net.amygdalum.testrecorder.runtime.MapMatcher;
import net.amygdalum.testrecorder.types.Computation;
import net.amygdalum.testrecorder.types.DeserializerContext;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.types.TypeManager;
import net.amygdalum.testrecorder.util.Pair;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedMap;
import net.amygdalum.testrecorder.values.SerializedNull;
import org.hamcrest.Matcher;

public class DefaultMapAdaptor
extends DefaultMatcherGenerator<SerializedMap>
implements MatcherGenerator<SerializedMap> {
    private SimpleValueAdaptor simpleAdaptor = new SimpleValueAdaptor();

    @Override
    public Class<SerializedMap> getAdaptedClass() {
        return SerializedMap.class;
    }

    @Override
    public Computation tryDeserialize(SerializedMap value, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        if (value.isEmpty()) {
            TypeManager types = context.getTypes();
            types.staticImport(MapMatcher.class, "noEntries");
            types.registerTypes(this.mapKeyType(types, value), this.mapValueType(types, value));
            String noEntriesMatcher = this.matchEmpty(context, value);
            return Computation.expression(noEntriesMatcher, (Type)Types.parameterized(Matcher.class, null, (Type[])new Type[]{Types.wildcard()}), Collections.emptyList());
        }
        TypeManager types = context.getTypes();
        types.staticImport(MapMatcher.class, "containsEntries");
        types.registerTypes(this.mapKeyType(types, value), this.mapValueType(types, value));
        EntryDeserializer deserializer = new EntryDeserializer(generator, this.simpleAdaptor, context, this.mapKeyType(types, value), this.mapValueType(types, value));
        List elements = value.entrySet().stream().map(x$0 -> deserializer.computeKeyValues(x$0)).collect(Collectors.toList());
        List<String> entryStatements = elements.stream().flatMap(pair -> Stream.concat(((Computation)pair.getElement1()).getStatements().stream(), ((Computation)pair.getElement2()).getStatements().stream())).collect(Collectors.toList());
        List<Pair<String, String>> entryValues = elements.stream().map(pair -> new Pair((Object)((Computation)pair.getElement1()).getValue(), (Object)((Computation)pair.getElement2()).getValue())).collect(Collectors.toList());
        String containsEntriesMatcher = this.matchElements(context, value, entryValues);
        return Computation.expression(containsEntriesMatcher, (Type)Types.parameterized(Matcher.class, null, (Type[])new Type[]{Types.wildcard()}), entryStatements);
    }

    private String matchElements(DeserializerContext context, SerializedMap value, List<Pair<String, String>> entryValues) {
        TypeManager types = context.getTypes();
        if (this.hasErasedType(types, value)) {
            return Templates.containsEntriesMatcher(null, null, entryValues);
        }
        String keyType = this.keyType(context, value);
        String valueType = this.valueType(context, value);
        return Templates.containsEntriesMatcher(keyType, valueType, entryValues);
    }

    private String matchEmpty(DeserializerContext context, SerializedMap value) {
        TypeManager types = context.getTypes();
        if (this.hasErasedType(types, value)) {
            return Templates.noEntriesMatcher(null, null);
        }
        String keyType = this.keyType(context, value);
        String valueType = this.valueType(context, value);
        return Templates.noEntriesMatcher(keyType, valueType);
    }

    private String valueType(DeserializerContext context, SerializedMap value) {
        TypeManager types = context.getTypes();
        Type mapValueType = this.mapValueType(types, value);
        String valueType = types.getRawClass(mapValueType);
        if (Types.isGeneric((Type)mapValueType)) {
            valueType = context.adapt(valueType, (Type)Types.parameterized(Class.class, null, (Type[])new Type[]{mapValueType}), (Type)Types.parameterized(Class.class, null, (Type[])new Type[]{Types.wildcard()}));
        }
        return valueType;
    }

    private String keyType(DeserializerContext context, SerializedMap value) {
        TypeManager types = context.getTypes();
        Type mapKeyType = this.mapKeyType(types, value);
        String keyType = types.getRawClass(mapKeyType);
        if (Types.isGeneric((Type)mapKeyType)) {
            keyType = context.adapt(keyType, (Type)Types.parameterized(Class.class, null, (Type[])new Type[]{mapKeyType}), (Type)Types.parameterized(Class.class, null, (Type[])new Type[]{Types.wildcard()}));
        }
        return keyType;
    }

    private Type mapValueType(TypeManager types, SerializedMap value) {
        Object mapValueType = value.getMapValueType();
        if (types.isHidden((Type)mapValueType)) {
            mapValueType = Object.class;
        }
        return mapValueType;
    }

    private Type mapKeyType(TypeManager types, SerializedMap value) {
        Object mapKeyType = value.getMapKeyType();
        if (types.isHidden((Type)mapKeyType)) {
            mapKeyType = Object.class;
        }
        return mapKeyType;
    }

    private boolean hasErasedType(TypeManager types, SerializedMap value) {
        Type collectionType = types.mostSpecialOf(value.getUsedTypes()).orElse(value.getType());
        return this.mapKeyType(types, value) == Object.class && this.mapValueType(types, value) == Object.class && collectionType instanceof Class;
    }

    private static class EntryDeserializer {
        private Deserializer generator;
        private SimpleValueAdaptor simpleAdaptor;
        private DeserializerContext context;
        private Type mapKeyType;
        private Type mapValueType;

        EntryDeserializer(Deserializer generator, SimpleValueAdaptor simpleAdaptor, DeserializerContext context, Type mapKeyType, Type mapValueType) {
            this.generator = generator;
            this.simpleAdaptor = simpleAdaptor;
            this.context = context;
            this.mapKeyType = mapKeyType;
            this.mapValueType = mapValueType;
        }

        private Pair<Computation, Computation> computeKeyValues(Map.Entry<SerializedValue, SerializedValue> entry) {
            Type valueType;
            TypeManager types = this.context.getTypes();
            SerializedValue key = entry.getKey();
            SerializedValue value = entry.getValue();
            Computation keyDeserialized = this.simpleAdaptor.tryDeserialize(key, this.generator);
            Computation valueDeserialized = this.simpleAdaptor.tryDeserialize(value, this.generator);
            Type keyType = key instanceof SerializedNull ? null : (Type)((Object)types.mostSpecialOf(key.getUsedTypes()).orElse((Type)((Object)Object.class)));
            Type type = valueType = value instanceof SerializedNull ? null : (Type)((Object)types.mostSpecialOf(value.getUsedTypes()).orElse((Type)((Object)Object.class)));
            if (Types.assignableTypes((Type)this.mapKeyType, (Type)keyType) && Types.assignableTypes(Matcher.class, (Type)keyType)) {
                String keyTypeName = types.getRawTypeName(this.mapKeyType);
                keyDeserialized = new Computation(Templates.cast(keyTypeName, keyDeserialized.getValue()), keyDeserialized.getType(), false, keyDeserialized.getStatements());
            }
            if (Types.assignableTypes((Type)this.mapValueType, (Type)valueType) && Types.assignableTypes(Matcher.class, (Type)valueType)) {
                String valueTypeName = types.getRawTypeName(this.mapValueType);
                valueDeserialized = new Computation(Templates.cast(valueTypeName, valueDeserialized.getValue()), valueDeserialized.getType(), false, valueDeserialized.getStatements());
            }
            return new Pair((Object)keyDeserialized, (Object)valueDeserialized);
        }
    }
}

