/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.matcher;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Optional;
import net.amygdalum.testrecorder.deserializers.Deserializer;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.matcher.DefaultMatcherGenerator;
import net.amygdalum.testrecorder.deserializers.matcher.MatcherGenerator;
import net.amygdalum.testrecorder.types.Computation;
import net.amygdalum.testrecorder.types.DeserializerContext;
import net.amygdalum.testrecorder.types.TypeManager;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedNull;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class DefaultNullAdaptor
extends DefaultMatcherGenerator<SerializedNull>
implements MatcherGenerator<SerializedNull> {
    @Override
    public Class<SerializedNull> getAdaptedClass() {
        return SerializedNull.class;
    }

    @Override
    public Computation tryDeserialize(SerializedNull value, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        TypeManager types = context.getTypes();
        types.registerType(value.getType());
        types.registerTypes(value.getUsedTypes());
        types.staticImport(CoreMatchers.class, "nullValue");
        Optional<Type> usedType = types.mostSpecialOf(value.getUsedTypes());
        if (usedType.isPresent()) {
            Type visibleUsedType = usedType.get();
            String nullMatcher = Templates.nullMatcher(types.getRawClass(visibleUsedType));
            return Computation.expression(nullMatcher, (Type)Types.parameterized(Matcher.class, null, (Type[])new Type[]{visibleUsedType}), Collections.emptyList());
        }
        String nullMatcher = Templates.nullMatcher("");
        return Computation.expression(nullMatcher, (Type)Types.parameterized(Matcher.class, null, (Type[])new Type[]{Types.wildcard()}), Collections.emptyList());
    }
}

