/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.matcher;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.amygdalum.testrecorder.deserializers.Deserializer;
import net.amygdalum.testrecorder.deserializers.FieldNamingStrategy;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.matcher.DefaultMatcherGenerator;
import net.amygdalum.testrecorder.deserializers.matcher.MatcherGenerator;
import net.amygdalum.testrecorder.runtime.GenericMatcher;
import net.amygdalum.testrecorder.types.Computation;
import net.amygdalum.testrecorder.types.DeserializerContext;
import net.amygdalum.testrecorder.types.TypeManager;
import net.amygdalum.testrecorder.util.SerializableParameterizedType;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedObject;
import org.hamcrest.Matcher;

public class DefaultObjectAdaptor
extends DefaultMatcherGenerator<SerializedObject>
implements MatcherGenerator<SerializedObject> {
    @Override
    public Class<SerializedObject> getAdaptedClass() {
        return SerializedObject.class;
    }

    @Override
    public Computation tryDeserialize(SerializedObject value, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        TypeManager types = context.getTypes();
        types.registerTypes(new Type[]{value.getType(), GenericMatcher.class});
        types.registerTypes(value.getUsedTypes());
        List fields = FieldNamingStrategy.ensureUniqueNames(value.getFields()).stream().sorted().map(field -> field.accept(generator)).filter(Objects::nonNull).collect(Collectors.toList());
        List<String> fieldComputations = fields.stream().flatMap(field -> field.getStatements().stream()).collect(Collectors.toList());
        List<String> fieldAssignments = fields.stream().map(field -> field.getValue()).collect(Collectors.toList());
        Type usedType = (Type)((Object)types.mostSpecialOf(value.getUsedTypes()).orElse((Type)((Object)Object.class)));
        Object matchedType = types.isHidden(usedType) ? Types.wildcard() : usedType;
        SerializableParameterizedType resultType = Types.parameterized(Matcher.class, null, (Type[])new Type[]{matchedType});
        String matcherExpression = this.with(types).createMatcherExpression(value, fieldAssignments);
        return Computation.expression(matcherExpression, (Type)resultType, fieldComputations);
    }

    public TypesAware with(TypeManager types) {
        return new TypesAware(types);
    }

    private static class TypesAware {
        private TypeManager types;

        TypesAware(TypeManager types) {
            this.types = types;
        }

        public String createMatcherExpression(SerializedObject value, List<String> fieldAssignments) {
            Class<?> type = value.getType();
            Type usedType = this.types.mostSpecialOf(value.getUsedTypes()).orElse(type);
            if (Types.baseType((Type)usedType) == Matcher.class) {
                usedType = (Type)Types.typeArgument((Type)usedType, (int)0).orElse(Types.wildcard());
            }
            String matcherRawType = this.types.getRawClass(type);
            String matcherToType = this.types.getRawClass(usedType);
            if (matcherToType.equals(matcherRawType)) {
                return Templates.genericObjectMatcher(matcherRawType, fieldAssignments);
            }
            return Templates.genericObjectMatcher(matcherRawType, matcherToType, fieldAssignments);
        }
    }
}

