/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.matcher;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.amygdalum.testrecorder.deserializers.Deserializer;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.matcher.DefaultMatcherGenerator;
import net.amygdalum.testrecorder.deserializers.matcher.MatcherGenerator;
import net.amygdalum.testrecorder.deserializers.matcher.SimpleValueAdaptor;
import net.amygdalum.testrecorder.runtime.ContainsMatcher;
import net.amygdalum.testrecorder.types.Computation;
import net.amygdalum.testrecorder.types.DeserializerContext;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.types.TypeManager;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedSet;
import org.hamcrest.Matcher;

public class DefaultSetAdaptor
extends DefaultMatcherGenerator<SerializedSet>
implements MatcherGenerator<SerializedSet> {
    private SimpleValueAdaptor simpleAdaptor = new SimpleValueAdaptor();

    @Override
    public Class<SerializedSet> getAdaptedClass() {
        return SerializedSet.class;
    }

    @Override
    public Computation tryDeserialize(SerializedSet value, Deserializer generator) {
        DeserializerContext context = generator.getContext();
        if (value.isEmpty()) {
            TypeManager types = context.getTypes();
            types.staticImport(ContainsMatcher.class, "empty");
            types.registerImport(Types.baseType((Type)this.componentType(types, value)));
            return Computation.expression(this.matchEmpty(context, value), (Type)Types.parameterized(Matcher.class, null, (Type[])new Type[]{Types.wildcard()}), Collections.emptyList());
        }
        TypeManager types = context.getTypes();
        types.staticImport(ContainsMatcher.class, "contains");
        types.registerImport(Types.baseType((Type)this.componentType(types, value)));
        List elements = value.stream().map(element -> this.simpleAdaptor.tryDeserialize((SerializedValue)element, generator)).collect(Collectors.toList());
        List<String> elementComputations = elements.stream().flatMap(element -> element.getStatements().stream()).collect(Collectors.toList());
        String[] elementValues = (String[])elements.stream().map(element -> element.getValue()).toArray(String[]::new);
        String containsInAnyOrderMatcher = this.matchElements(context, value, elementValues);
        return Computation.expression(containsInAnyOrderMatcher, (Type)Types.parameterized(Matcher.class, null, (Type[])new Type[]{Types.wildcard()}), elementComputations);
    }

    private String matchElements(DeserializerContext context, SerializedSet value, String[] elementValues) {
        TypeManager types = context.getTypes();
        if (this.hasErasedType(types, value)) {
            return Templates.containsInAnyOrderMatcher(null, elementValues);
        }
        Type componentType = this.componentType(types, value);
        String elementType = types.getRawClass(componentType);
        if (Types.isGeneric((Type)componentType)) {
            elementType = context.adapt(elementType, (Type)Types.parameterized(Class.class, null, (Type[])new Type[]{componentType}), (Type)Types.parameterized(Class.class, null, (Type[])new Type[]{Types.wildcard()}));
        }
        return Templates.containsInAnyOrderMatcher(elementType, elementValues);
    }

    private String matchEmpty(DeserializerContext context, SerializedSet value) {
        TypeManager types = context.getTypes();
        if (this.hasErasedType(types, value)) {
            return Templates.emptyMatcher(null);
        }
        return Templates.emptyMatcher(types.getRawClass(this.componentType(types, value)));
    }

    private boolean hasErasedType(TypeManager types, SerializedSet value) {
        Type collectionType = types.mostSpecialOf(value.getUsedTypes()).orElse(value.getType());
        return this.componentType(types, value) == Object.class && collectionType instanceof Class;
    }

    private Type componentType(TypeManager types, SerializedSet value) {
        Object componentType = value.getComponentType();
        if (types.isHidden((Type)componentType)) {
            componentType = Object.class;
        }
        return componentType;
    }
}

