/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.matcher;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Optional;
import net.amygdalum.testrecorder.deserializers.Deserializer;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.matcher.DefaultArrayAdaptor;
import net.amygdalum.testrecorder.deserializers.matcher.MatcherGenerator;
import net.amygdalum.testrecorder.hints.LoadFromFile;
import net.amygdalum.testrecorder.types.Computation;
import net.amygdalum.testrecorder.types.DeserializationException;
import net.amygdalum.testrecorder.types.DeserializerContext;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.types.TypeManager;
import net.amygdalum.testrecorder.util.FileSerializer;
import net.amygdalum.testrecorder.util.Literals;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedArray;
import net.amygdalum.testrecorder.values.SerializedLiteral;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class LargePrimitiveArrayAdaptor
implements MatcherGenerator<SerializedArray> {
    @Override
    public Class<SerializedArray> getAdaptedClass() {
        return SerializedArray.class;
    }

    @Override
    public Class<? extends MatcherGenerator<SerializedArray>> parent() {
        return DefaultArrayAdaptor.class;
    }

    @Override
    public boolean matches(Type type) {
        return true;
    }

    @Override
    public Computation tryDeserialize(SerializedArray value, Deserializer generator) {
        Optional<LoadFromFile> hint;
        DeserializerContext context = generator.getContext();
        TypeManager types = context.getTypes();
        Class<?> componentType = Types.baseType((Type)value.getComponentType());
        while (componentType.isArray()) {
            componentType = componentType.getComponentType();
        }
        if (Types.isLiteral((Type)componentType) && (hint = context.getHint(value, LoadFromFile.class)).isPresent()) {
            try {
                LoadFromFile loadFromFile = hint.get();
                types.registerType((Type)((Object)FileSerializer.class));
                types.staticImport(CoreMatchers.class, "equalTo");
                Object object = this.unwrap(value);
                String fileName = new FileSerializer(loadFromFile.writeTo()).store(object);
                String base = Templates.newObject(types.getConstructorTypeName((Type)((Object)FileSerializer.class)), Literals.asLiteral((String)loadFromFile.readFrom()));
                String result = Templates.callMethod(base, "load", Literals.asLiteral((String)fileName), types.getRawClass(value.getType()));
                String matcher = Templates.equalToMatcher(result);
                return Computation.expression(matcher, Matcher.class);
            }
            catch (IOException e) {
                throw new DeserializationException("failed deserializing: " + value, e);
            }
        }
        throw new DeserializationException("failed deserializing: " + value);
    }

    private Object unwrap(SerializedArray value) {
        SerializedValue[] serializedArray = value.getArray();
        Class componentType = Types.baseType((Type)value.getComponentType());
        Object array = Array.newInstance(componentType, serializedArray.length);
        for (int i = 0; i < serializedArray.length; ++i) {
            Array.set(array, i, this.unwrap(serializedArray[i]));
        }
        return array;
    }

    private Object unwrap(SerializedValue value) {
        if (value instanceof SerializedLiteral) {
            return ((SerializedLiteral)value).getValue();
        }
        if (value instanceof SerializedArray) {
            return this.unwrap((SerializedArray)value);
        }
        throw new DeserializationException("failed deserializing: " + value);
    }
}

