/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.matcher;

import java.lang.reflect.Type;
import net.amygdalum.testrecorder.deserializers.Adaptors;
import net.amygdalum.testrecorder.deserializers.Deserializer;
import net.amygdalum.testrecorder.deserializers.DeserializerFactory;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.matcher.MatcherGenerator;
import net.amygdalum.testrecorder.deserializers.matcher.SimpleValueAdaptor;
import net.amygdalum.testrecorder.hints.SkipChecks;
import net.amygdalum.testrecorder.profile.AgentConfiguration;
import net.amygdalum.testrecorder.runtime.GenericMatcher;
import net.amygdalum.testrecorder.types.Computation;
import net.amygdalum.testrecorder.types.DeserializerContext;
import net.amygdalum.testrecorder.types.SerializedArgument;
import net.amygdalum.testrecorder.types.SerializedField;
import net.amygdalum.testrecorder.types.SerializedImmutableType;
import net.amygdalum.testrecorder.types.SerializedReferenceType;
import net.amygdalum.testrecorder.types.SerializedResult;
import net.amygdalum.testrecorder.types.SerializedValue;
import net.amygdalum.testrecorder.types.SerializedValueType;
import net.amygdalum.testrecorder.types.TypeManager;
import net.amygdalum.testrecorder.util.SerializableParameterizedType;
import net.amygdalum.testrecorder.util.Types;
import org.hamcrest.Matcher;

public class MatcherGenerators
implements DeserializerFactory {
    private Adaptors adaptors;

    public MatcherGenerators(AgentConfiguration config) {
        this(new Adaptors().load(config.loadConfigurations(MatcherGenerator.class, new Object[0])));
    }

    public MatcherGenerators(Adaptors adaptors) {
        this.adaptors = adaptors;
    }

    @Override
    public Generator newGenerator(DeserializerContext context) {
        return new Generator(this.adaptors, context);
    }

    public static class Generator
    implements Deserializer {
        private Adaptors adaptors;
        private SimpleValueAdaptor simpleAdaptor;
        private DeserializerContext context;

        public Generator(Adaptors adaptors, DeserializerContext context) {
            this.adaptors = adaptors;
            this.simpleAdaptor = new SimpleValueAdaptor();
            this.context = context;
        }

        @Override
        public DeserializerContext getContext() {
            return this.context;
        }

        @Override
        public Computation visitField(SerializedField field) {
            return this.context.withRole(field, this::generateField);
        }

        private Computation generateField(SerializedField field) {
            TypeManager types = this.context.getTypes();
            SerializedValue fieldValue = field.getValue();
            if (this.context.getHint(field, SkipChecks.class).isPresent()) {
                return null;
            }
            if (this.simpleAdaptor.isSimpleValue(fieldValue)) {
                Type fieldType = field.getType();
                Type fieldResultType = types.bestType(fieldType, Object.class);
                types.registerImport(Types.baseType((Type)fieldResultType));
                Computation value = this.simpleAdaptor.tryDeserialize(fieldValue, (Deserializer)this);
                String assignField = Templates.fieldDeclaration(null, types.getVariableTypeName(fieldResultType), field.getName(), value.getValue());
                return Computation.expression(assignField, null, value.getStatements());
            }
            types.registerImport(Matcher.class);
            Computation value = fieldValue.accept(this);
            String genericType = types.getVariableTypeName((Type)Types.parameterized(Matcher.class, null, (Type[])new Type[]{Types.wildcard()}));
            String assignField = Templates.fieldDeclaration(null, genericType, field.getName(), value.getValue());
            return Computation.expression(assignField, null, value.getStatements());
        }

        @Override
        public Computation visitArgument(SerializedArgument argument) {
            return this.context.withRole(argument, this::generateArgument);
        }

        private Computation generateArgument(SerializedArgument argument) {
            SerializedValue argumentValue = argument.getValue();
            if (this.context.getHint(argument, SkipChecks.class).isPresent()) {
                return null;
            }
            return argumentValue.accept(this);
        }

        @Override
        public Computation visitResult(SerializedResult result) {
            return this.context.withRole(result, this::generateResult);
        }

        private Computation generateResult(SerializedResult result) {
            SerializedValue resultValue = result.getValue();
            if (this.context.getHint(result, SkipChecks.class).isPresent()) {
                return null;
            }
            return resultValue.accept(this);
        }

        @Override
        public Computation visitReferenceType(SerializedReferenceType value) {
            return this.context.withRole(value, this::generateReferenceType);
        }

        private Computation generateReferenceType(SerializedReferenceType value) {
            TypeManager types = this.context.getTypes();
            Type usedType = (Type)((Object)types.mostSpecialOf(value.getUsedTypes()).orElse((Type)((Object)Object.class)));
            if (this.context.getHint(value, SkipChecks.class).isPresent()) {
                return null;
            }
            if (this.context.isComputed(value)) {
                SerializableParameterizedType resultType;
                types.staticImport(GenericMatcher.class, "recursive");
                SerializableParameterizedType serializableParameterizedType = resultType = usedType.equals(value.getType()) ? Types.parameterized(Matcher.class, null, (Type[])new Type[]{usedType}) : Types.parameterized(Matcher.class, null, (Type[])new Type[]{Types.wildcard()});
                if (!types.isHidden(value.getType())) {
                    return Computation.expression(Templates.recursiveMatcher(types.getRawClass(value.getType())), (Type)resultType);
                }
                if (!types.isHidden(usedType)) {
                    return Computation.expression(Templates.recursiveMatcher(types.getRawClass(usedType)), (Type)resultType);
                }
                return Computation.expression(Templates.recursiveMatcher(types.getRawClass((Type)((Object)Object.class))), (Type)Types.parameterized(Matcher.class, null, (Type[])new Type[]{Types.wildcard()}));
            }
            return this.adaptors.tryDeserialize(value, types, this);
        }

        @Override
        public Computation visitImmutableType(SerializedImmutableType value) {
            return this.context.withRole(value, this::generateImmutableType);
        }

        private Computation generateImmutableType(SerializedImmutableType value) {
            TypeManager types = this.context.getTypes();
            if (this.context.getHint(value, SkipChecks.class).isPresent()) {
                return null;
            }
            return this.adaptors.tryDeserialize(value, types, this);
        }

        @Override
        public Computation visitValueType(SerializedValueType value) {
            return this.context.withRole(value, this::generateValueType);
        }

        private Computation generateValueType(SerializedValueType value) {
            TypeManager types = this.context.getTypes();
            if (this.context.getHint(value, SkipChecks.class).isPresent()) {
                return null;
            }
            return this.adaptors.tryDeserialize(value, types, this);
        }
    }
}

